/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.protocol.fgftp;

import com.macromedia.generator.protocol.fgftp.FgftpDirectoryThread;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import sun.net.ProgressData;
import sun.net.ProgressEntry;
import sun.net.TransferProtocolClient;
import sun.net.ftp.FtpClient;
import sun.net.www.MessageHeader;
import sun.net.www.MeteredStream;

public class FgftpURLConnection
extends sun.net.www.URLConnection {
    InputStream is = null;
    FtpClient ftp = null;

    public FgftpURLConnection(URL uRL) {
        super(uRL);
    }

    public synchronized void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String string = FgftpURLConnection.parseHostRegion(this.url.toString());
        String string2 = FgftpURLConnection.parseHostname(string);
        String string3 = FgftpURLConnection.parseUsername(string);
        String string4 = FgftpURLConnection.parsePassword(string);
        int n = this.url.getPort();
        if (n < 0) {
            n = 21;
        }
        try {
            this.ftp = new FtpClient(string2, n);
        }
        catch (UnknownHostException unknownHostException) {
            System.err.println(unknownHostException + " - " + string2 + ": Is domain needed?");
            throw unknownHostException;
        }
        if (string3 == null) {
            string3 = "anonymous";
        }
        if (string4 == null) {
            string4 = System.getProperty("ftp.protocol.user", "Java" + System.getProperty("java.version") + "@");
        }
        this.ftp.login(string3, string4);
    }

    private static String parseHostRegion(String string) {
        String string2 = "";
        if ((string = string.trim()).regionMatches(true, 0, "fgftp://", 0, 8)) {
            int n = string.indexOf(47, 8);
            if (n < 0) {
                n = string.indexOf(63, 8);
            }
            if (n < 0) {
                n = string.indexOf(35, 8);
            }
            if (n < 0) {
                n = string.length();
            }
            string2 = string.substring(8, n);
        }
        return string2;
    }

    private static String parseHostname(String string) {
        String string2 = string;
        int n = string2.indexOf(64);
        if (n > -1) {
            string2 = string2.substring(n + 1, string2.length());
        }
        if ((n = string2.indexOf(58)) > -1) {
            string2 = string2.substring(0, n);
        }
        return string2;
    }

    private static String parseUsername(String string) {
        String string2 = null;
        int n = string.indexOf(64);
        if (n > -1) {
            string2 = string.substring(0, n);
            n = string.indexOf(124);
            if (n > -1) {
                string2 = string2.substring(0, n);
            }
        }
        return string2;
    }

    private static String parsePassword(String string) {
        String string2 = null;
        int n = string.indexOf(64);
        if (n > -1) {
            String string3 = string.substring(0, n);
            n = string.indexOf(124);
            if (n > -1) {
                string2 = string3.substring(n + 1, string3.length());
            }
        }
        return string2;
    }

    public InputStream getInputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        if (this.is != null) {
            return this.is;
        }
        MessageHeader messageHeader = new MessageHeader();
        try {
            String string;
            this.ftp.binary();
            this.is = this.ftp.get(this.url.getFile());
            try {
                string = ((TransferProtocolClient)((Object)this.ftp)).getResponseString();
                int n = string.indexOf(" bytes)");
                if (n != -1) {
                    char c;
                    int n2 = n;
                    while (--n2 >= 0 && (c = string.charAt(n2)) >= '0' && c <= '9') {
                    }
                    n2 = Integer.parseInt(string.substring(n2 + 1, n));
                    messageHeader.add("content-length", "" + n2);
                    if (n2 > 0) {
                        ProgressEntry progressEntry = new ProgressEntry(this.url.getFile(), null);
                        progressEntry.update(0, n2);
                        ProgressData.pdata.register(progressEntry);
                        this.is = new MeteredStream(this.is, progressEntry);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            string = URLConnection.guessContentTypeFromName(this.url.getFile());
            if (string == null && this.is.markSupported()) {
                string = URLConnection.guessContentTypeFromStream(this.is);
            }
            if (string != null) {
                messageHeader.add("content-type", string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.ftp.cd(this.url.getFile());
            this.ftp.ascii();
            PipedOutputStream pipedOutputStream = new PipedOutputStream();
            this.is = new PipedInputStream(pipedOutputStream);
            new FgftpDirectoryThread(this, this.ftp, this.url, this.ftp.list(), pipedOutputStream).start();
            messageHeader.add("content-type", "text/html");
        }
        this.setProperties(messageHeader);
        return this.is;
    }

    String guessContentTypeFromFilename(String string) {
        return URLConnection.guessContentTypeFromName(string);
    }
}

