/*
 * Decompiled with CFR 0.152.
 */
package com.macromedia.generator.api;

import com.macromedia.generator.api.GenObject;
import com.macromedia.generator.api.GeneratorApiException;
import com.macromedia.generator.api.peer.ColorPeer;

public class Color
extends GenObject {
    public Color() throws GeneratorApiException {
        this.peer = ColorPeer.New();
        if (this.peer == 0) {
            throw new GeneratorApiException("unable to create peer");
        }
    }

    protected Color(int n) throws GeneratorApiException {
        this.peer = n;
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
    }

    protected void finalize() throws Throwable {
        if (this.peer != 0) {
            ColorPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void release() {
        if (this.peer != 0) {
            ColorPeer.Release(this.peer);
        }
        this.peer = 0;
    }

    public void setRed(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ColorPeer.SetRed(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting red");
        }
    }

    public int getRed() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ColorPeer.GetRed(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting red");
        }
        return nArray[0];
    }

    public void setGreen(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ColorPeer.SetGreen(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting green");
        }
    }

    public int getGreen() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ColorPeer.GetGreen(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting green");
        }
        return nArray[0];
    }

    public void setBlue(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ColorPeer.SetBlue(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting blue");
        }
    }

    public int getBlue() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ColorPeer.GetBlue(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting blue");
        }
        return nArray[0];
    }

    public void setAlpha(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ColorPeer.SetAlpha(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting alpha");
        }
    }

    public int getAlpha() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ColorPeer.GetAlpha(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting alpha");
        }
        return nArray[0];
    }

    public void setRgb(int n) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n2 = ColorPeer.SetRgb(this.peer, n);
        if (n2 == 0) {
            throw new GeneratorApiException("error setting rgb");
        }
    }

    public void setRGBValue(String string) throws GeneratorApiException {
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ColorPeer.SetRgbValue(this.peer, string);
        if (n == 0) {
            throw new GeneratorApiException("error setting rgb");
        }
    }

    public static int getRGBValue(String string) throws GeneratorApiException {
        int[] nArray = new int[]{0};
        int n = ColorPeer.GetRgbValue(string, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error setting rgb");
        }
        return nArray[0];
    }

    public static int getRedValue(int n) {
        int n2 = ColorPeer.GetRedValue(n);
        return n2;
    }

    public static int getGreenValue(int n) {
        int n2 = ColorPeer.GetGreenValue(n);
        return n2;
    }

    public static int getBlueValue(int n) {
        int n2 = ColorPeer.GetBlueValue(n);
        return n2;
    }

    public static int getRGBValue(int n, int n2, int n3) {
        int n4 = ColorPeer.GetRgbValue(n, n2, n3);
        return n4;
    }

    public static int getReducedColor(int n) {
        int n2 = ColorPeer.GetReducedColor(n);
        return n2;
    }

    public static int makeWebSafeColor(int n) {
        int n2 = ColorPeer.MakeWebSafeColor(n);
        return n2;
    }

    public int getRgb() throws GeneratorApiException {
        int[] nArray = new int[]{0};
        if (this.peer == 0) {
            throw new GeneratorApiException("invalid peer");
        }
        int n = ColorPeer.GetRgb(this.peer, nArray);
        if (n == 0) {
            throw new GeneratorApiException("error getting rgb");
        }
        return nArray[0];
    }
}

