#ifndef _MM_JSAPI_ENVIRONMENT_H_
#define _MM_JSAPI_ENVIRONMENT_H_

/*****************************************************************************
 * Private data types, macros, and globals
 ****************************************************************************/

typedef struct {
	JSObject *libObj;
	JSBool (*defineFunction)(JSObject *libObj, char *name, JSNative call, unsigned int nargs);
	char *(*valueToString)(JSContext *cx, jsval v, unsigned int *pLength);
	JSBool (*valueToInteger)(JSContext *cx, jsval v, long *lp);
	JSBool (*valueToDouble)(JSContext *cx, jsval v, double *dp);
	JSBool (*valueToBoolean)(JSContext *cx, jsval v, JSBool *bp);
	JSBool (*valueToObject)(JSContext *cx, jsval v, JSObject **op);
	JSBool (*stringToValue)(JSContext *cx, char *b, unsigned int sz, jsval *vp);
	
	JSBool (*doubleToValue)(JSContext *cx, double dv, jsval *vp);
	char *(*objectType)(JSObject *obj);
	JSObject *(*newArrayObject)(JSContext *cx, unsigned int length, jsval *vp);
	long (*getArrayLength)(JSContext *cx, JSObject *obj);
	JSBool (*getElement)(JSContext *cx, JSObject *obj, unsigned int idx, jsval *vp);
	JSBool (*setElement)(JSContext *cx, JSObject *obj, unsigned int idx, jsval *vp);
	JSBool (*executeScript)(JSContext *cx, JSObject *obj, char *script,
							unsigned int sz, const char *file, unsigned int lineNum, jsval *rval);
	JSBool (*reportError)(JSContext *cx, char *error, unsigned int sz);
	
	JSBool (*getJavaVM)(void **jvm, void** env);	// for private internal use
	jschar *(*valueToUCString)(JSContext *cx, jsval v, unsigned int *pLength);
	JSBool (*ucstringToValue)(JSContext *cx, jschar *c, unsigned int sz, jsval *vp);
	
	JSObject *(*getConfigFolderList)(JSContext *cx, char *fileUrl, char *constraints);
	JSBool (*configFileExists)(char *fileURL);
	int (*openConfigFile)(char *fileURL, char *mode);
	JSBool (*getConfigFileAttributes)(char *fileUrl, unsigned long* attrs, unsigned long* filesize,
									  unsigned long* modtime, unsigned long* createtime);
	JSBool (*setConfigFileAttributes)(char *fileURL, unsigned long attrs);
	JSBool (*createConfigFolder)(char *fileURL);
	JSBool (*removeConfigFolder)(char *fileURL);
	JSBool (*deleteConfigFile)(char *fileURL);
} MM_Environment;


#endif /* _MM_JSAPI_ENVIRONMENT_H_ */
