/*
 * Decompiled with CFR 0.152.
 */
package com.techtrader.modules.tools.bytecode;

import com.techtrader.modules.tools.bytecode.Code;
import com.techtrader.modules.tools.bytecode.Instruction;
import com.techtrader.modules.tools.bytecode.visitor.BCVisitor;

public class StackInstruction
extends Instruction {
    public StackInstruction setType(Class clazz) {
        boolean bl = clazz.equals(Long.TYPE) || clazz.equals(Double.TYPE);
        this.calculateOpCode(bl);
        return this;
    }

    public StackInstruction setTypeName(String string) {
        boolean bl = string.equals("long") || string.equals("double");
        this.calculateOpCode(bl);
        return this;
    }

    public int getStackChange() {
        switch (this._opcode) {
            case 87: {
                return -1;
            }
            case 88: {
                return -2;
            }
            case 89: 
            case 90: 
            case 91: {
                return 1;
            }
            case 92: 
            case 93: 
            case 94: {
                return 2;
            }
        }
        return 0;
    }

    private void calculateOpCode(boolean bl) {
        switch (this._opcode) {
            case 87: {
                if (!bl) break;
                this._opcode = 88;
                break;
            }
            case 88: {
                if (bl) break;
                this._opcode = 87;
                break;
            }
            case 89: {
                if (!bl) break;
                this._opcode = 92;
                break;
            }
            case 92: {
                if (bl) break;
                this._opcode = 89;
                break;
            }
            case 90: {
                if (!bl) break;
                this._opcode = 93;
                break;
            }
            case 93: {
                if (bl) break;
                this._opcode = 90;
                break;
            }
            case 91: {
                if (!bl) break;
                this._opcode = 94;
                break;
            }
            case 94: {
                if (bl) break;
                this._opcode = 91;
                break;
            }
        }
    }

    public void acceptVisit(BCVisitor bCVisitor) {
        bCVisitor.enterStackInstruction(this);
        bCVisitor.exitStackInstruction(this);
    }

    protected StackInstruction(Code code, int n) {
        super(code);
        this._opcode = n;
    }
}

