CREATE MEMORY TABLE Schema(
	id										INTEGER NOT NULL PRIMARY KEY,
	version									INTEGER NOT NULL
);

CREATE CACHED TABLE ADLock(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation								INTEGER NOT NULL,
	
	lockToken 								VARCHAR(128) NOT NULL, 
	ownerName 								VARCHAR(64) NOT NULL,
	myLock 									BOOLEAN
);
	
CREATE CACHED TABLE Asset(
	id 										INTEGER NOT NULL PRIMARY KEY,	
	generation								INTEGER NOT NULL,
	
	unionType 								VARCHAR(16) NOT NULL,
	remoteId 								VARCHAR(64),
	projectId 								INTEGER,
	type 									VARCHAR(16),
	namespace 								VARCHAR(64),
	name 									VARCHAR(240),
	creationTime							BIGINT,
	modificationTime 						BIGINT,
	path 									VARCHAR(255),
	parentId								INTEGER,
	reference 								VARCHAR(128),
	visibility 								VARCHAR(16),
	isProtected 							BOOLEAN,
	basicCache 								VARCHAR(32),
	propertiesCache 						VARCHAR(32),
	versionsCache 							VARCHAR(32),
	childBasicCache 						INTEGER,
	childPropertiesCache 					INTEGER,
	childVersionsCache 						INTEGER,
	linkedAssetId 							INTEGER,
	headVersionId 							INTEGER,
	workingCopyId 							INTEGER,
	lockId 									INTEGER,
	infoText 								VARCHAR(1024),
	shared 									BOOLEAN,
	rootContainerId 						INTEGER
);

CREATE IDX_Asset_1 ON Asset (parentId);
	
CREATE CACHED TABLE AssetProperty(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	name 									VARCHAR(240) NOT NULL,
	type 									VARCHAR(16) NOT NULL,
	intValue 								INTEGER,
	floatValue								FLOAT,
	dateValue 								TIMESTAMP,
	booleanValue 							BOOLEAN,
	stringValue 							LONGVARCHAR,
	binValue								LONGVARBINARY,
	assetId 								INTEGER
);

	
CREATE CACHED TABLE MountPoint(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	localPath 								VARCHAR(255),
	username 								VARCHAR(64),
	password 								VARCHAR(64),
	active 									BOOLEAN,
	serverId 								INTEGER NOT NULL
);
	
CREATE CACHED TABLE Resource(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	type 									VARCHAR(255) NOT NULL,
	name 									VARCHAR(255) NOT NULL,
	mimetype 								VARCHAR(255) NOT NULL,
	data 									LONGVARBINARY NOT NULL
);
	
CREATE CACHED TABLE Script(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	type 									VARCHAR(255) NOT NULL,
	mimetype								VARCHAR(255) NOT NULL,
	isCompiled 								BOOLEAN NOT NULL,
	data 									LONGVARBINARY,
	assetId 								INTEGER NOT NULL
);	
	
CREATE MEMORY TABLE Sequence(
	name 									VARCHAR(64) NOT NULL PRIMARY KEY,
	bound 									INTEGER
);
	
CREATE CACHED TABLE Server(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	name 									VARCHAR(64) NOT NULL,
	version 								VARCHAR(16) NOT NULL,
	url 									VARBINARY(255) NOT NULL,
	guid 									VARCHAR(64) NOT NULL,
	local 									BOOLEAN NOT NULL,
	automounted 							BOOLEAN NOT NULL
);
	
CREATE CACHED TABLE Thumbnail(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	type 									VARCHAR(16) NOT NULL,
	data 									LONGVARBINARY NOT NULL,
	width 									INTEGER,
	height 									INTEGER,
	format 									VARCHAR(32) NOT NULL,
	versionId 								INTEGER
);
	
CREATE CACHED TABLE VNode(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	mountPointId 							INTEGER NOT NULL,
	assetId 								INTEGER,
	versionId 								INTEGER
);

CREATE INDEX IDX_VNode_1 ON VNode(assetId);
CREATE INDEX IDX_VNode_1 ON VNode(versionId);
	
CREATE CACHED TABLE Version(
	id										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	remoteId 								VARCHAR(64),
	comment 								LONGVARCHAR,
	deleted 								BOOLEAN,
	explicit								BOOLEAN,
	versionNumber 							INTEGER,
	modificationTime 						BIGINT,
	modificationUsername 					VARCHAR(64),
	mimetype 								VARCHAR(100),
	contentSize 							BIGINT,
	propertiesCache 						VARCHAR(32),
	thumbnailCache 							VARCHAR(32),
	xmpCache 								VARCHAR(32),
	assetId 								INTEGER NOT NULL,
	baseVersionId 							INTEGER,
	xmpMetadataId 							INTEGER
);
	
CREATE CACHED TABLE VersionProperty(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	name 									VARCHAR(240) NOT NULL,
	type 									VARCHAR(16) NOT NULL,
	intValue 								INTEGER,
	floatValue								FLOAT,
	dateValue 								TIMESTAMP,
	booleanValue 							BOOLEAN,
	stringValue 							LONGVARCHAR,
	binValue								LONGVARBINARY,
	versionId 								INTEGER
);
	
CREATE CACHED TABLE XmpMetadata(
	id 										INTEGER NOT NULL PRIMARY KEY,
	generation 								INTEGER NOT NULL,
	
	type 									VARBINARY(255) NOT NULL,
	xmpPacket								LONGVARBINARY NOT NULL
);


CREATE CACHED TABLE ACTION(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,TYPE VARCHAR(255) NOT NULL,VALUE VARCHAR(255) NOT NULL,EXTENSIONDISPATCHINFOID INTEGER NOT NULL);
CREATE CACHED TABLE APPLICATION(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,APPLICATIONID VARCHAR(255) NOT NULL,NAME VARCHAR(255) NOT NULL,MAJORVERSION VARCHAR(255) NOT NULL,MINORVERSION VARCHAR(255) NOT NULL,APPLICATIONSID INTEGER NOT NULL);
CREATE CACHED TABLE APPLICATIONS(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY);
CREATE CACHED TABLE DISPATCHLIST(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY);
CREATE CACHED TABLE EXTENSION(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,EXTENSIONID VARCHAR(255) NOT NULL,MINPLUGPLUGVERSION VARCHAR(255),NAME VARCHAR(255) NOT NULL,TYPE VARCHAR(255),PLAYER INTEGER,PREFERENCES INTEGER,EXTENSIONSID INTEGER NOT NULL,CONSTRAINT SYS_CT_60 UNIQUE(PLAYER,PREFERENCES));
CREATE CACHED TABLE EXTENSIONBUNDLE(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,EXTENSIONBUNDLEID VARCHAR(255) NOT NULL,VERSION VARCHAR(255) NOT NULL,REMOTEURI VARCHAR(255) NOT NULL,LOCALURI VARCHAR(255) NOT NULL,USERMANIFESTID INTEGER NOT NULL);
CREATE CACHED TABLE EXTENSIONDISPATCHINFO(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,LOCALE VARCHAR(255) NOT NULL,HOSTID VARCHAR(255) NOT NULL,EXTENSIONID VARCHAR(255) NOT NULL,ENGINEID VARCHAR(255),SWFPATH VARCHAR(255) NOT NULL,SCRIPTPATH VARCHAR(255),ICONPATHNORMAL VARCHAR(255),ICONPATHDISABLED VARCHAR(255),ICONPATHROLLOVER VARCHAR(255),UI INTEGER,DISPATCHLISTID INTEGER NOT NULL,CONSTRAINT SYS_CT_66 UNIQUE(UI),CONSTRAINT FKB72FAA07F094E33E FOREIGN KEY(DISPATCHLISTID) REFERENCES DISPATCHLIST(id));
CREATE CACHED TABLE EXTENSIONLIST(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY);
CREATE CACHED TABLE EXTENSIONS(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY);
CREATE CACHED TABLE HOST(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,HOSTID VARCHAR(255) NOT NULL,EXTENSIONLISTID INTEGER NOT NULL,CONSTRAINT FK2269C88EA10B42 FOREIGN KEY(EXTENSIONLISTID) REFERENCES EXTENSIONLIST(id));
CREATE CACHED TABLE HOSTEXTENSION(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,HOSTEXTENSIONID VARCHAR(255) NOT NULL,PRIORITY INTEGER NOT NULL,HOSTID INTEGER NOT NULL,CONSTRAINT FK51D353574078693E FOREIGN KEY(HOSTID) REFERENCES HOST(id));
CREATE CACHED TABLE INITIALGEOMETRY(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,WIDTH INTEGER NOT NULL,HEIGHT INTEGER NOT NULL,X INTEGER NOT NULL,Y INTEGER NOT NULL);
CREATE CACHED TABLE MANIFEST(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,VERSION VARCHAR(255) NOT NULL,UPDATESITE INTEGER,EXTENSIONS INTEGER,APPLICATIONS INTEGER,EXTENSIONLIST INTEGER,DISPATCHLIST INTEGER,CONSTRAINT SYS_CT_80 UNIQUE(UPDATESITE,EXTENSIONS,APPLICATIONS,EXTENSIONLIST,DISPATCHLIST),CONSTRAINT FKBA3924FE0C40219 FOREIGN KEY(APPLICATIONS) REFERENCES APPLICATIONS(id),CONSTRAINT FKBA3924F76B0E167 FOREIGN KEY(EXTENSIONLIST) REFERENCES EXTENSIONLIST(id),CONSTRAINT FKBA3924FD43E7C23 FOREIGN KEY(DISPATCHLIST) REFERENCES DISPATCHLIST(id),CONSTRAINT FKBA3924F623968BB FOREIGN KEY(EXTENSIONS) REFERENCES EXTENSIONS(id));
CREATE CACHED TABLE MENU(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,CUSTOMPLACEMENT VARCHAR(255),MENUITEM INTEGER,EXTENSIONDISPATCHINFOID INTEGER NOT NULL,CONSTRAINT SYS_CT_84 UNIQUE(MENUITEM),CONSTRAINT FK24897F9F5E80F6 FOREIGN KEY(EXTENSIONDISPATCHINFOID) REFERENCES EXTENSIONDISPATCHINFO(id));
CREATE CACHED TABLE MENUITEM(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,LABEL VARCHAR(255) NOT NULL,MENUITEMID INTEGER,CONSTRAINT FKDFD8A13226EA37F2 FOREIGN KEY(MENUITEMID) REFERENCES MENUITEM(id));
CREATE CACHED TABLE PLAYER(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,TYPE VARCHAR(255) NOT NULL,VERSION VARCHAR(255) NOT NULL);
CREATE CACHED TABLE PREFERENCE(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,KEY VARCHAR(255),TYPE VARCHAR(255) NOT NULL,VALUE VARCHAR(255),PREFERENCEID INTEGER NOT NULL);
CREATE CACHED TABLE PREFERENCES(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY);
CREATE CACHED TABLE SIZE(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,WIDTH INTEGER NOT NULL,HEIGHT INTEGER NOT NULL);
CREATE CACHED TABLE UI(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,TYPE VARCHAR(255) NOT NULL,VISIBLE BOOLEAN NOT NULL,INITIALGEOMETRY INTEGER,MINSIZE INTEGER,MAXSIZE INTEGER,CONSTRAINT SYS_CT_112 UNIQUE(INITIALGEOMETRY,MINSIZE,MAXSIZE),CONSTRAINT FKA947C3FEED9 FOREIGN KEY(INITIALGEOMETRY) REFERENCES INITIALGEOMETRY(id),CONSTRAINT FKA947EE18EC6 FOREIGN KEY(MINSIZE) REFERENCES SIZE(id),CONSTRAINT FKA9464ADDAEA FOREIGN KEY(MAXSIZE) REFERENCES SIZE(id));
CREATE CACHED TABLE UPDATESITE(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,URL VARCHAR(255) NOT NULL,TTL BIGINT NOT NULL,ETAG VARCHAR(255) NOT NULL);
CREATE CACHED TABLE USERMANIFEST(id INTEGER GENERATED BY DEFAULT AS IDENTITY(START WITH 1) NOT NULL PRIMARY KEY,TTL BIGINT NOT NULL,ETAG VARCHAR(255) NOT NULL);


INSERT INTO Schema VALUES (0, 0);

