/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.persistence.factories;

import com.adobe.drive.data.internal.model.SequenceManager;
import com.adobe.drive.data.internal.model.Thumbnail;
import com.adobe.drive.data.internal.persistence.PersistenceException;
import com.adobe.drive.data.internal.persistence.Session;
import com.adobe.drive.data.internal.persistence.UnitOfWork;
import com.adobe.drive.data.model.asset.IModelObject;
import com.adobe.drive.data.model.asset.IThumbnail;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import com.adobe.drive.data.model.asset.ThumbnailFactory;
import java.io.IOException;
import java.io.InputStream;
import org.hibernate.HibernateException;

public class ThumbnailFactory
implements ThumbnailFactory.IFactory {
    public IThumbnail createThumbnail(int width, int height, String format, byte[] data) throws ModelException {
        try {
            int thumbnailId = SequenceManager.getInstance().createThumbnailId();
            Thumbnail result = new Thumbnail(thumbnailId);
            result.setFormat(format);
            result.setWidth(width);
            result.setHeight(height);
            result.setData(data);
            UnitOfWork.currentUnitOfWork().store((IModelObject)result);
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IThumbnail createThumbnail(int width, int height, String format, InputStream inputStream) throws ModelException, IOException {
        try {
            int thumbnailId = SequenceManager.getInstance().createThumbnailId();
            Thumbnail result = new Thumbnail(thumbnailId);
            result.setFormat(format);
            result.setWidth(width);
            result.setHeight(height);
            result.setData(inputStream);
            UnitOfWork.currentUnitOfWork().store((IModelObject)result);
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IThumbnail findThumbnailById(int id) throws ModelException {
        try {
            IThumbnail result = (IThumbnail)Session.currentSession().get(Thumbnail.class, new Integer(id));
            if (result == null) {
                String message = "Cannot find Thumbnail with id=" + id;
                throw new ModelObjectNotFoundException(message);
            }
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }
}

