/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.persistence.factories;

import com.adobe.drive.data.internal.model.SequenceManager;
import com.adobe.drive.data.internal.model.Server;
import com.adobe.drive.data.internal.persistence.PersistenceException;
import com.adobe.drive.data.internal.persistence.Session;
import com.adobe.drive.data.internal.persistence.UnitOfWork;
import com.adobe.drive.data.model.IServer;
import com.adobe.drive.data.model.ServerFactory;
import com.adobe.drive.data.model.asset.IModelObject;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import com.adobe.drive.data.persistence.api.IQuery;
import java.net.URI;
import java.util.List;
import org.hibernate.HibernateException;

public class ServerFactory
implements ServerFactory.IFactory {
    public IServer[] getAllServers() throws ModelException {
        try {
            IQuery query = Session.currentSession().getNamedQuery("Server.findAll");
            List result = query.list();
            if (result == null) {
                return new IServer[0];
            }
            return result.toArray(new IServer[result.size()]);
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IServer findServerById(int id) throws ModelObjectNotFoundException, ModelException {
        try {
            IServer result = (IServer)Session.currentSession().get(Server.class, new Integer(id));
            if (result == null) {
                String message = "Cannot find Server with id=" + id;
                throw new ModelObjectNotFoundException(message);
            }
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IServer findServerByGuid(String serverGuid) throws ModelException {
        assert (serverGuid != null) : "serverGuid != null";
        try {
            IQuery query = Session.currentSession().getNamedQuery("Server.findByGuid");
            query.setParameter("guid", (Object)serverGuid);
            return (IServer)query.get();
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IServer createServer(String name, String version, URI uri, String guid, boolean isLocal, boolean autoMounted) throws ModelException {
        try {
            int serverId = SequenceManager.getInstance().createServerId();
            Server server = new Server(serverId);
            server.setName(name);
            server.setVersion(version);
            server.setUrl(uri);
            server.setGuid(guid);
            server.setLocal(isLocal);
            server.setAutoMounted(autoMounted);
            UnitOfWork.currentUnitOfWork().store((IModelObject)server);
            return server;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IServer findServerByUri(URI serverUri) throws ModelException {
        assert (serverUri != null) : "serverUri != null";
        try {
            IQuery query = Session.currentSession().getNamedQuery("Server.findByUri");
            query.setParameter("uri", (Object)serverUri);
            return (IServer)query.get();
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }
}

