/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.persistence.factories;

import com.adobe.drive.data.internal.model.Script;
import com.adobe.drive.data.internal.model.SequenceManager;
import com.adobe.drive.data.internal.persistence.Session;
import com.adobe.drive.data.internal.persistence.UnitOfWork;
import com.adobe.drive.data.model.IScript;
import com.adobe.drive.data.model.ScriptFactory;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IModelObject;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import com.adobe.drive.data.model.asset.ScriptTypeEnum;
import com.adobe.drive.data.persistence.api.IQuery;
import java.io.InputStream;
import java.util.List;

public class ScriptFactory
implements ScriptFactory.IPersistentFactory {
    public IScript createScript(IAsset asset, ScriptTypeEnum type, String mimetype, boolean isCompiled, InputStream data) throws ModelException {
        int id = SequenceManager.getInstance().createScriptId();
        Script script = new Script(id);
        script.setAsset(asset);
        script.setType(type);
        script.setMimetype(mimetype);
        script.setIsCompiled(isCompiled);
        script.setDataStream(data);
        UnitOfWork.currentUnitOfWork().store((IModelObject)script);
        return script;
    }

    public IScript createFromTemplate(IScript template) throws ModelException {
        throw new UnsupportedOperationException("not implemented");
    }

    public IScript findScriptById(int id) throws ModelObjectNotFoundException {
        IScript script = (IScript)Session.currentSession().get(Script.class, new Integer(id));
        if (script == null) {
            throw new ModelObjectNotFoundException("Cannot find Script with id=" + id);
        }
        return script;
    }

    public IScript[] findScript(int assetId, ScriptTypeEnum type) {
        assert (type != null) : "type";
        IQuery query = Session.currentSession().getNamedQuery("Script.findByAssetId");
        query.setParameter("assetId", (Object)assetId);
        List result = query.list();
        if (result == null) {
            return new IScript[0];
        }
        return result.toArray(new IScript[result.size()]);
    }
}

