/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.persistence.factories;

import com.adobe.drive.data.internal.model.Resource;
import com.adobe.drive.data.internal.model.SequenceManager;
import com.adobe.drive.data.internal.persistence.PersistenceException;
import com.adobe.drive.data.internal.persistence.Session;
import com.adobe.drive.data.internal.persistence.UnitOfWork;
import com.adobe.drive.data.model.IResource;
import com.adobe.drive.data.model.ResourceFactory;
import com.adobe.drive.data.model.asset.IModelObject;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.hibernate.HibernateException;

public class ResourceFactory
implements ResourceFactory.IFactory {
    public IResource createResource(String name, String type, String mimetype, InputStream data) throws ModelException {
        try {
            int resourceId = SequenceManager.getInstance().createResourceId();
            Resource resource = new Resource(resourceId);
            resource.setFormat(name);
            resource.setType(type);
            resource.setMimetype(mimetype);
            resource.setData(data);
            UnitOfWork.currentUnitOfWork().store((IModelObject)resource);
            return resource;
        }
        catch (IOException e) {
            throw new ModelException(e.getMessage());
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IResource findResourceById(int id) throws ModelObjectNotFoundException, ModelException {
        try {
            IResource result = (IResource)Session.currentSession().get(Resource.class, new Integer(id));
            if (result == null) {
                String message = "Cannot find Resource with id=" + id;
                throw new ModelObjectNotFoundException(message);
            }
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }
}

