/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.persistence.factories;

import com.adobe.drive.data.internal.model.SequenceManager;
import com.adobe.drive.data.internal.model.XMPMetadata;
import com.adobe.drive.data.internal.persistence.PersistenceException;
import com.adobe.drive.data.internal.persistence.Session;
import com.adobe.drive.data.internal.persistence.UnitOfWork;
import com.adobe.drive.data.model.asset.IModelObject;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import com.adobe.drive.data.model.metadata.IXMPMetadata;
import com.adobe.drive.data.model.metadata.MetadataFactory;
import com.adobe.drive.data.model.metadata.XMPMetadataTypeEnum;
import java.io.IOException;
import java.io.InputStream;
import org.hibernate.HibernateException;

public class MetadataFactory
implements MetadataFactory.IFactory {
    public IXMPMetadata createXMPMetadata(XMPMetadataTypeEnum type, byte[] bytes) throws ModelException {
        try {
            int metadataId = SequenceManager.getInstance().createXMPMetadataId();
            XMPMetadata result = new XMPMetadata(metadataId);
            result.setType(type);
            result.setData(bytes);
            UnitOfWork.currentUnitOfWork().store((IModelObject)result);
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IXMPMetadata createXMPMetadata(XMPMetadataTypeEnum type, InputStream inputStream) throws IOException, ModelException {
        try {
            int metadataId = SequenceManager.getInstance().createXMPMetadataId();
            XMPMetadata result = new XMPMetadata(metadataId);
            result.setType(type);
            result.setData(inputStream);
            UnitOfWork.currentUnitOfWork().store((IModelObject)result);
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IXMPMetadata findXMPMetadataById(int id) throws ModelObjectNotFoundException, ModelException {
        try {
            IXMPMetadata result = (IXMPMetadata)Session.currentSession().get(XMPMetadata.class, new Integer(id));
            if (result == null) {
                String message = "Cannot find XMPMetadata with id=" + id;
                throw new ModelObjectNotFoundException(message);
            }
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }
}

