/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.persistence.factories;

import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.drive.data.internal.model.Asset;
import com.adobe.drive.data.internal.model.AssetProperty;
import com.adobe.drive.data.internal.model.AssetReference;
import com.adobe.drive.data.internal.model.Lock;
import com.adobe.drive.data.internal.model.MountPoint;
import com.adobe.drive.data.internal.model.Project;
import com.adobe.drive.data.internal.model.SequenceManager;
import com.adobe.drive.data.internal.model.VNode;
import com.adobe.drive.data.internal.model.Version;
import com.adobe.drive.data.internal.model.VersionProperty;
import com.adobe.drive.data.internal.persistence.PersistenceException;
import com.adobe.drive.data.internal.persistence.Session;
import com.adobe.drive.data.internal.persistence.UnitOfWork;
import com.adobe.drive.data.model.IServer;
import com.adobe.drive.data.model.asset.AssetFactory;
import com.adobe.drive.data.model.asset.AssetTypeEnum;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IAssetProperty;
import com.adobe.drive.data.model.asset.ILock;
import com.adobe.drive.data.model.asset.IModelObject;
import com.adobe.drive.data.model.asset.IMountPoint;
import com.adobe.drive.data.model.asset.IProject;
import com.adobe.drive.data.model.asset.IVNode;
import com.adobe.drive.data.model.asset.IVersion;
import com.adobe.drive.data.model.asset.IVersionProperty;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.model.asset.ModelObjectNotFoundException;
import com.adobe.drive.data.model.asset.MountPointFactory;
import com.adobe.drive.data.model.asset.VNodeId;
import com.adobe.drive.data.model.asset.Visibility;
import com.adobe.drive.data.persistence.api.IQuery;
import com.adobe.drive.utils.Path;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.hibernate.HibernateException;

public class AssetFactory
implements AssetFactory.IFactory,
MountPointFactory.IFactory {
    private final Logger LOG = Logger.getLogger(AssetFactory.class);

    public IMountPoint[] findAllMountPoints() throws ModelException {
        try {
            IQuery query = Session.currentSession().getNamedQuery("MountPoint.findAll");
            List result = query.list();
            if (result == null) {
                return new IMountPoint[0];
            }
            return result.toArray(new IMountPoint[result.size()]);
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IMountPoint findMountPointById(int id) throws ModelObjectNotFoundException, ModelException {
        try {
            IMountPoint result = (IMountPoint)Session.currentSession().get(MountPoint.class, new Integer(id));
            if (result == null) {
                String message = "Cannot find MountPoint with id=" + id;
                throw new ModelObjectNotFoundException(message);
            }
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IMountPoint findMountPointByLocalPath(Path localPath) throws ModelException {
        assert (localPath != null) : "localPath != null";
        try {
            String path = localPath.forceAbsolute().forcePathToFolder().toString();
            IQuery query = Session.currentSession().getNamedQuery("MountPoint.findByLocalPath");
            query.setParameter("localPath", (Object)path);
            return (IMountPoint)query.get();
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IMountPoint findMountPointByRemoteUriAndUsername(URI remoteUri, String username) throws ModelException {
        assert (remoteUri != null) : "remoteUri != null";
        assert (username != null) : "username != null";
        try {
            Session session = Session.currentSession();
            IQuery query = session.getNamedQuery("MountPoint.findByRemoteUriAndUsername");
            query.setParameter("remoteUri", (Object)remoteUri);
            query.setParameter("username", (Object)username);
            return (IMountPoint)query.get();
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IMountPoint[] findMountPointsByServerGuid(String serverGuid) throws ModelObjectNotFoundException, ModelException {
        assert (serverGuid != null) : "serverGuid != null";
        try {
            IQuery query = Session.currentSession().getNamedQuery("MountPoint.findByServerGuid");
            query.setParameter("serverGuid", (Object)serverGuid);
            List result = query.list();
            if (result == null) {
                return new IMountPoint[0];
            }
            return result.toArray(new IMountPoint[result.size()]);
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IMountPoint createMountPoint(Path localPath, IServer server, String username, String password) throws ModelException {
        assert (server != null) : "server != null";
        assert (username != null) : "username != null";
        assert (password != null) : "password != null";
        try {
            int mountPointId = SequenceManager.getInstance().createMountPointId();
            MountPoint result = new MountPoint(mountPointId);
            if (localPath != null) {
                result.setLocalPath(localPath.forceAbsolute().forcePathToFile().toString());
            }
            result.setServer(server);
            result.setUsername(username);
            result.setPassword(password);
            UnitOfWork.currentUnitOfWork().store((IModelObject)result);
            return result;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public void remove(IMountPoint mountPoint) throws ModelException {
        assert (mountPoint != null) : "mountPoint != null";
        try {
            UnitOfWork uow = UnitOfWork.currentUnitOfWork();
            IQuery query = Session.currentSession().getNamedQuery("VNode.findByMount");
            query.setParameter("mountId", (Object)mountPoint.getId());
            for (IModelObject mo : query.list()) {
                uow.deleteObject(mo);
            }
            uow.deleteObject((IModelObject)mountPoint);
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IAsset findAssetById(int assetId) throws ModelObjectNotFoundException {
        IAsset result = (IAsset)Session.currentSession().get(Asset.class, new Integer(assetId));
        if (result == null) {
            throw new ModelObjectNotFoundException("Cannot find Asset with id=" + assetId);
        }
        return result;
    }

    public IAsset findAssetByReference(String reference) throws ModelObjectNotFoundException {
        assert (reference != null) : "reference != null";
        AssetReference assetReference = new AssetReference(reference);
        String serverGuid = assetReference.getServerGUID();
        ArrayList<Integer> mountPointIds = new ArrayList<Integer>();
        try {
            IMountPoint[] mountPoints;
            IMountPoint[] iMountPointArray = mountPoints = this.findMountPointsByServerGuid(serverGuid);
            int n = mountPoints.length;
            int n2 = 0;
            while (n2 < n) {
                IMountPoint mountPoint = iMountPointArray[n2];
                if (mountPoint.isActive()) {
                    mountPointIds.add(mountPoint.getId());
                }
                ++n2;
            }
        }
        catch (ModelException e) {
            throw new ModelObjectNotFoundException(e.getMessage());
        }
        IAsset asset = null;
        for (Integer mountPointId : mountPointIds) {
            IQuery query = Session.currentSession().getNamedQuery("Asset.findByReference");
            query.setParameter("reference", (Object)reference);
            query.setParameter("mountPointId", (Object)mountPointId);
            asset = (IAsset)query.get();
            if (asset != null) break;
        }
        return asset;
    }

    public void createVNode(IVersion version) throws ModelException {
        assert (version != null) : "version != null";
        int vnodeId = SequenceManager.getInstance().createVNodeId();
        VNode vnode = new VNode(vnodeId, version.getAsset().getMountPoint());
        version.setVNode((IVNode)vnode);
        vnode.setVersion(version);
        UnitOfWork.currentUnitOfWork().store((IModelObject)version);
    }

    public IVNode findVNodeById(VNodeId vnodeId) throws ModelObjectNotFoundException {
        IVNode result = (IVNode)Session.currentSession().get(VNode.class, Integer.valueOf(vnodeId.toInt()));
        if (result == null) {
            throw new ModelObjectNotFoundException("Cannot find VNode with id=" + vnodeId);
        }
        return result;
    }

    public IAsset findAssetByRemoteId(int mountPointId, String remoteId, String namespace) {
        assert (remoteId != null) : "remoteId != null";
        if (remoteId.equals("LOCAL")) {
            return null;
        }
        IQuery query = null;
        if (namespace == null) {
            query = Session.currentSession().getNamedQuery("Asset.findByRemoteIdNSNull");
            query.setParameter("mountPointId", (Object)mountPointId);
            query.setParameter("remoteId", (Object)remoteId);
        } else {
            query = Session.currentSession().getNamedQuery("Asset.findByRemoteId");
            query.setParameter("mountPointId", (Object)mountPointId);
            query.setParameter("remoteId", (Object)remoteId);
            query.setParameter("namespace", (Object)namespace);
        }
        return (IAsset)query.get();
    }

    public IAsset findAssetByPath(int mountPointId, String path) {
        assert (path != null) : "remoteId != null";
        IQuery query = Session.currentSession().getNamedQuery("Asset.findByPath");
        query.setParameter("mountPointId", (Object)mountPointId);
        query.setParameter("path", (Object)path);
        return (IAsset)query.get();
    }

    public IAsset createAsset(IMountPoint mountPoint, String namespace, String name, long creationDate) throws ModelException {
        assert (mountPoint != null) : "mountPoint != null";
        assert (name != null) : "name != null";
        int assetId = SequenceManager.getInstance().createAssetId();
        int vnodeId = SequenceManager.getInstance().createVNodeId();
        Asset result = new Asset(assetId, AssetTypeEnum.FILE, namespace, (IVNode)new VNode(vnodeId, mountPoint));
        result.setName(name);
        result.setCreationTime(creationDate);
        result.setModificationTime(creationDate);
        UnitOfWork.currentUnitOfWork().store((IModelObject)result);
        return result;
    }

    public IAsset createLocalAsset(IMountPoint mountPoint, String namespace, String name, long creationDate) throws ModelException {
        assert (mountPoint != null) : "mountPoint != null";
        assert (name != null) : "name != null";
        int assetId = SequenceManager.getInstance().createAssetId();
        int vnodeId = SequenceManager.getInstance().createVNodeId();
        Asset result = new Asset(assetId, AssetTypeEnum.FILE_LOCAL, namespace, (IVNode)new VNode(vnodeId, mountPoint));
        result.setName(name);
        result.setCreationTime(creationDate);
        result.setModificationTime(creationDate);
        UnitOfWork.currentUnitOfWork().store((IModelObject)result);
        return result;
    }

    public IAssetProperty createAssetProperty(IAsset asset, String key, Object value) throws ModelException {
        assert (asset != null) : "asset != null";
        assert (key != null) : "key != null";
        assert (value != null) : "value != null";
        int propertyId = SequenceManager.getInstance().createAssetPropertyId();
        AssetProperty result = new AssetProperty(propertyId, asset, key, value);
        UnitOfWork.currentUnitOfWork().store((IModelObject)result);
        return result;
    }

    public IAsset createAssetContainer(IMountPoint mountPoint, String namespace, String name, long creationDate) throws ModelException {
        assert (mountPoint != null) : "mountPoint != null";
        assert (name != null) : "name != null";
        int assetId = SequenceManager.getInstance().createAssetId();
        int vnodeId = SequenceManager.getInstance().createVNodeId();
        Asset result = new Asset(assetId, AssetTypeEnum.FILE_CONTAINER, namespace, (IVNode)new VNode(vnodeId, mountPoint));
        result.setName(name);
        result.setCreationTime(creationDate);
        result.setModificationTime(creationDate);
        UnitOfWork.currentUnitOfWork().store((IModelObject)result);
        return result;
    }

    public IProject createProject(IMountPoint mountPoint, String namespace, String name, long creationDate) throws ModelException {
        assert (mountPoint != null) : "mountPoint != null";
        assert (name != null) : "name != null";
        int projectId = SequenceManager.getInstance().createAssetId();
        int vnodeId = SequenceManager.getInstance().createVNodeId();
        Project result = new Project(projectId, namespace, (IVNode)new VNode(vnodeId, mountPoint));
        result.setName(name);
        result.setCreationTime(creationDate);
        result.setModificationTime(creationDate);
        UnitOfWork.currentUnitOfWork().store((IModelObject)result);
        return result;
    }

    public IVersion createVersion(IAsset asset, boolean isHead) throws ModelException {
        assert (asset != null) : "asset != null";
        int versionId = SequenceManager.getInstance().createVersionId();
        int vnodeId = SequenceManager.getInstance().createVNodeId();
        Version result = new Version(versionId, asset, (IVNode)new VNode(vnodeId, asset.getMountPoint()));
        ((Asset)asset).addVersion((IVersion)result, isHead);
        UnitOfWork.currentUnitOfWork().store((IModelObject)result);
        return result;
    }

    public IVersionProperty createVersionProperty(IVersion version, String key, Object value) throws ModelException {
        assert (version != null) : "version != null";
        assert (key != null) : "key != null";
        assert (value != null) : "value != null";
        int propertyId = SequenceManager.getInstance().createVersionPropertyId();
        VersionProperty result = new VersionProperty(propertyId, version, key, value);
        UnitOfWork.currentUnitOfWork().store((IModelObject)result);
        return result;
    }

    public boolean removeVersion(IVersion version) {
        if (((Asset)version.getAsset()).removeVersion(version)) {
            UnitOfWork.currentUnitOfWork().deleteObject((IModelObject)version);
            return true;
        }
        return false;
    }

    public ILock createLock(String lockToken, String ownerName, boolean callingUserIsLockOwner) throws ModelException {
        assert (lockToken != null) : "lockToken != null";
        assert (ownerName != null) : "ownerName != null";
        int lockId = SequenceManager.getInstance().createLockId();
        Lock lock = new Lock(lockId);
        lock.setLockToken(lockToken);
        lock.setOwnerName(ownerName);
        lock.setMyLock(callingUserIsLockOwner);
        UnitOfWork.currentUnitOfWork().store((IModelObject)lock);
        return lock;
    }

    public ILock findLockById(int lockId) throws ModelObjectNotFoundException {
        ILock result = (ILock)Session.currentSession().get(Lock.class, new Integer(lockId));
        if (result == null) {
            throw new ModelObjectNotFoundException("Cannot find Lock with id=" + lockId);
        }
        return result;
    }

    public IAsset[] findLockedAssets(Integer[] mountPointIds, Path[] filter, boolean onlyLockedByMe) throws ModelException {
        IAsset asset;
        int i;
        int ansResults;
        String queryName = onlyLockedByMe ? "Asset.findLockedByMe" : "Asset.findLocked";
        ArrayList<IAsset> filteredAssets = new ArrayList<IAsset>();
        IQuery query = Session.currentSession().getNamedQuery(queryName);
        query.setParameterList("mountPointIds", (Object[])mountPointIds);
        List result = query.list();
        if (result != null) {
            ansResults = result.size();
            i = 0;
            while (i < ansResults) {
                asset = (IAsset)result.get(i);
                if (this.filterApplies(asset, filter)) {
                    filteredAssets.add(asset);
                }
                ++i;
            }
        }
        if (onlyLockedByMe) {
            query = Session.currentSession().getNamedQuery("Asset.findWorkingCopies");
            query.setParameterList("mountPointIds", (Object[])mountPointIds);
            query.setParameter("localFileType", (Object)AssetTypeEnum.FILE_LOCAL);
            result = query.list();
            if (result != null) {
                ansResults = result.size();
                i = 0;
                while (i < ansResults) {
                    asset = (IAsset)result.get(i);
                    if (this.filterApplies(asset, filter)) {
                        filteredAssets.add(asset);
                    }
                    ++i;
                }
            }
        }
        return filteredAssets.toArray(new IAsset[filteredAssets.size()]);
    }

    public IAsset[] findAssetsByType(Path[] filter, AssetTypeEnum type) throws ModelException {
        IQuery query = Session.currentSession().getNamedQuery("Asset.findByType");
        query.setParameter("type", (Object)type);
        query.setParameter("visibility", (Object)Visibility.VISIBLE);
        List result = query.list();
        if (result != null) {
            int ansResults = result.size();
            ArrayList<IAsset> filteredAssets = new ArrayList<IAsset>(ansResults);
            int i = 0;
            while (i < ansResults) {
                IAsset asset = (IAsset)result.get(i);
                if (this.filterApplies(asset, filter)) {
                    filteredAssets.add(asset);
                }
                ++i;
            }
            return filteredAssets.toArray(new IAsset[filteredAssets.size()]);
        }
        return new IAsset[0];
    }

    private boolean filterApplies(IAsset asset, Path[] filterPaths) {
        if (filterPaths == null || filterPaths.length == 0) {
            return false;
        }
        Path[] pathArray = filterPaths;
        int n = filterPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String path;
            Path filter = pathArray[n2];
            if (asset.getVisibility() != Visibility.UNLISTED && (path = asset.getPath()) != null && path.startsWith(filter.toString())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public IProject[] findProjectsByMountPointId(int mountPointId) {
        IQuery query = Session.currentSession().getNamedQuery("Asset.findProjectsByMountPoint");
        query.setParameter("mountPointId", (Object)mountPointId);
        List result = query.list();
        if (result == null) {
            return new IProject[0];
        }
        return result.toArray(new IProject[result.size()]);
    }

    public IProject findProjectByName(int mountPointId, String name) {
        assert (name != null) : "name != null";
        IQuery query = Session.currentSession().getNamedQuery("Asset.findProjectByName");
        query.setParameter("mountPointId", (Object)mountPointId);
        query.setParameter("name", (Object)name);
        return (IProject)query.get();
    }

    public IAsset[] findChildren(IAsset asset) {
        assert (asset != null) : "asset != null";
        IQuery query = Session.currentSession().getNamedQuery("Asset.findChildren");
        query.setParameter("parentId", (Object)asset.getId());
        String path = asset.getPath();
        String base = path.equals("/") ? "" : path;
        List result = query.list();
        if (result == null) {
            return new IAsset[0];
        }
        if (base.length() == 0) {
            Iterator it = result.iterator();
            while (it.hasNext()) {
                if (!((IAsset)it.next()).getPath().equals("/")) continue;
                it.remove();
            }
        }
        return result.toArray(new IAsset[result.size()]);
    }

    public IAsset[] findChildren(IAsset asset, int offset, int count, Visibility[] visibilities) throws ModelException {
        assert (asset != null) : "asset != null";
        try {
            IQuery query = Session.currentSession().getNamedQuery("Asset.findChildrenVisibility");
            query.setParameter("parentId", (Object)asset.getId());
            query.setParameterList("visibilities", (Object[])visibilities);
            String path = asset.getPath();
            String base = path.equals("/") ? "" : path;
            query.setFirstResult(offset);
            query.setMaxResults(count);
            List result = query.list();
            if (result == null) {
                return new IAsset[0];
            }
            if (base.length() == 0) {
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    if (!((IAsset)it.next()).getPath().equals("/")) continue;
                    it.remove();
                }
            }
            return result.toArray(new IAsset[result.size()]);
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IAsset findAssetByParentIdAndName(int parentId, String name) throws ModelException {
        assert (name != null) : "name != null";
        try {
            Session currentSession = Session.currentSession();
            IQuery query = currentSession.getNamedQuery("Asset.findAssetByParentIdAndName");
            query.setParameter("parentId", (Object)parentId);
            query.setParameter("name", (Object)name);
            return (IAsset)query.get();
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public IVersion findVersionById(int versionId) throws ModelObjectNotFoundException {
        IVersion result = (IVersion)Session.currentSession().get(Version.class, new Integer(versionId));
        if (result == null) {
            throw new ModelObjectNotFoundException("Cannot find Version with id=" + versionId);
        }
        return result;
    }

    public int[] findWorkingCopyIds(boolean includeLocal) throws ModelException {
        try {
            List result;
            StringBuilder query = new StringBuilder(100);
            HashMap<String, Object> params = new HashMap<String, Object>();
            query.append("SELECT version.id FROM Version AS version, Asset AS asset ");
            query.append("WHERE version.id = asset.workingCopyId ");
            if (!includeLocal) {
                query.append("AND asset.type = :type ");
                params.put("type", AssetTypeEnum.FILE);
            }
            if ((result = Session.currentSession().executeQuery(query.toString(), params)).size() == 0) {
                return new int[0];
            }
            Integer[] objects = result.toArray(new Integer[result.size()]);
            int[] primitive = new int[objects.length];
            int i = 0;
            while (i < objects.length) {
                primitive[i] = objects[i];
                ++i;
            }
            return primitive;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public int[] findWorkingCopyIds(int mountPointId, boolean includeLocal) throws ModelException {
        try {
            List result;
            StringBuilder query = new StringBuilder(100);
            HashMap<String, Object> params = new HashMap<String, Object>();
            query.append("SELECT version.id FROM Version AS version, Asset AS asset ");
            query.append("WHERE version.id = asset.workingCopyId ");
            query.append("AND asset.vnode.mountPointId = :mountPointId ");
            params.put("mountPointId", mountPointId);
            if (!includeLocal) {
                query.append("AND asset.type = :type ");
                params.put("type", AssetTypeEnum.FILE);
            }
            if ((result = Session.currentSession().executeQuery(query.toString(), params)).size() == 0) {
                return new int[0];
            }
            Integer[] objects = result.toArray(new Integer[result.size()]);
            int[] primitive = new int[objects.length];
            int i = 0;
            while (i < objects.length) {
                primitive[i] = objects[i];
                ++i;
            }
            return primitive;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public int[] findVersionIds(int mountPointId) throws ModelException {
        try {
            StringBuilder query = new StringBuilder(100);
            HashMap<String, Object> params = new HashMap<String, Object>();
            query.append("SELECT version.id FROM Version AS version ");
            query.append("WHERE version.vnode.mountPointId = :mountPointId ");
            params.put("mountPointId", mountPointId);
            List result = Session.currentSession().executeQuery(query.toString(), params);
            if (result.size() == 0) {
                return new int[0];
            }
            Integer[] objects = result.toArray(new Integer[result.size()]);
            int[] primitive = new int[objects.length];
            int i = 0;
            while (i < objects.length) {
                primitive[i] = objects[i];
                ++i;
            }
            return primitive;
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public void setMountPointsAsDeactivated() throws ModelException {
        try {
            Session.currentSession().executeUpdate("UPDATE MountPoint SET active = false, localpath = NULL", null);
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }

    public void killHorizontalRefs(int projectId) throws ModelException {
        String[] commands = new String[]{"UPDATE Asset SET linkedAssetId = NULL WHERE projectId = " + projectId, "UPDATE Version SET baseVersionId = NULL WHERE assetId IN (SELECT id FROM Asset WHERE projectId = " + projectId + ')'};
        try {
            String[] stringArray = commands;
            int n = commands.length;
            int n2 = 0;
            while (n2 < n) {
                String cmd = stringArray[n2];
                int affected = Session.currentSession().executeUpdate(cmd, null);
                if (this.LOG.isLogging(Level.DEBUG)) {
                    this.LOG.debug((Object)("killHorizontalRefs: Statement \"" + cmd + "\", Affected: " + affected));
                }
                ++n2;
            }
        }
        catch (HibernateException e) {
            throw PersistenceException.fromDBException(e);
        }
    }
}

