/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.persistence;

import com.adobe.drive.data.internal.persistence.ExceptionMapper;
import com.adobe.drive.data.internal.persistence.PersistenceException;
import com.adobe.drive.data.internal.persistence.Session;
import com.adobe.drive.data.model.asset.IModelObject;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.persistence.api.IUnitOfWork;
import com.adobe.drive.data.persistence.api.IUnitOfWorkListener;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;

public class UnitOfWork
implements IUnitOfWork {
    private static ThreadLocal<UnitOfWork> tlsUnitOfWork = new ThreadLocal();
    private Session session;
    private org.hibernate.Session hibernateSession;
    private Transaction transaction;
    private ExceptionMapper exceptionMapper;
    private Set<IUnitOfWorkListener> listeners;

    public static UnitOfWork currentUnitOfWork() {
        UnitOfWork result = tlsUnitOfWork.get();
        if (result == null) {
            throw new IllegalStateException("No active UnitOfWork.");
        }
        return result;
    }

    public static boolean hasUnitOfWork() {
        return tlsUnitOfWork.get() != null;
    }

    public UnitOfWork(SessionFactory sessionFactory, ExceptionMapper exceptionMapper) {
        assert (sessionFactory != null) : "hibernateSession != null";
        assert (exceptionMapper != null) : "exceptionMapper != null";
        this.hibernateSession = sessionFactory.openSession();
        this.exceptionMapper = exceptionMapper;
        this.session = new Session(this.hibernateSession, exceptionMapper);
        this.listeners = new HashSet<IUnitOfWorkListener>();
    }

    public void begin() {
        assert (this.hibernateSession != null) : "hibernateSession != null";
        this.transaction = this.hibernateSession.beginTransaction();
        tlsUnitOfWork.set(this);
    }

    public void commit() throws ModelException {
        assert (this.transaction != null) : "transaction != null";
        try {
            this.transaction.commit();
            this.notifyPostCommit();
        }
        catch (HibernateException e) {
            this.rollback();
            throw PersistenceException.fromDBException(e);
        }
        this.transaction = null;
        tlsUnitOfWork.remove();
        this.notifyCleanup();
    }

    public void rollback() {
        assert (this.transaction != null) : "transaction != null";
        try {
            this.transaction.rollback();
        }
        finally {
            this.transaction = null;
            tlsUnitOfWork.remove();
            this.notifyCleanup();
        }
    }

    public void store(IModelObject modelObject) throws ModelException {
        assert (this.hibernateSession != null) : "hibernateSession != null";
        try {
            this.hibernateSession.save((Object)modelObject);
        }
        catch (HibernateException e) {
            throw this.exceptionMapper.mapHibernateException(e);
        }
    }

    public void deleteObject(IModelObject modelObject) {
        if (modelObject == null) {
            return;
        }
        this.hibernateSession.delete((Object)modelObject);
    }

    public void addListener(IUnitOfWorkListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(IUnitOfWorkListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    private void notifyPostCommit() {
        IUnitOfWorkListener[] snapshot;
        IUnitOfWorkListener[] iUnitOfWorkListenerArray = snapshot = this.listeners.toArray(new IUnitOfWorkListener[this.listeners.size()]);
        int n = snapshot.length;
        int n2 = 0;
        while (n2 < n) {
            IUnitOfWorkListener listener = iUnitOfWorkListenerArray[n2];
            listener.postCommitTransaction((IUnitOfWork)this);
            ++n2;
        }
    }

    private void notifyCleanup() {
        IUnitOfWorkListener[] snapshot;
        IUnitOfWorkListener[] iUnitOfWorkListenerArray = snapshot = this.listeners.toArray(new IUnitOfWorkListener[this.listeners.size()]);
        int n = snapshot.length;
        int n2 = 0;
        while (n2 < n) {
            IUnitOfWorkListener listener = iUnitOfWorkListenerArray[n2];
            listener.cleanup((IUnitOfWork)this);
            ++n2;
        }
    }

    Session getSession() {
        return this.session;
    }
}

