/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.persistence;

import com.adobe.drive.data.internal.persistence.ExceptionMapper;
import com.adobe.drive.data.internal.persistence.Query;
import com.adobe.drive.data.internal.persistence.UnitOfWork;
import com.adobe.drive.data.model.asset.IAsset;
import com.adobe.drive.data.model.asset.IModelObject;
import com.adobe.drive.data.persistence.api.IQuery;
import com.adobe.drive.data.persistence.api.ISession;
import com.adobe.drive.data.persistence.api.IUnitOfWork;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.hibernate.SessionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Session
implements ISession {
    private static ThreadLocal<Session> tlsSession = new ThreadLocal();
    private SessionFactory sessionFactory;
    private org.hibernate.Session hibernateSession;
    private ExceptionMapper exceptionMapper;

    public static Session currentSession() {
        if (UnitOfWork.hasUnitOfWork()) {
            UnitOfWork unitOfWork = UnitOfWork.currentUnitOfWork();
            return unitOfWork.getSession();
        }
        Session result = tlsSession.get();
        if (result == null) {
            throw new IllegalStateException("No active Session.");
        }
        return result;
    }

    public static boolean hasSession() {
        return tlsSession.get() != null;
    }

    static Session createSession(SessionFactory sessionFactory, ExceptionMapper exceptionMapper) {
        Session result = new Session(sessionFactory, exceptionMapper);
        tlsSession.set(result);
        return result;
    }

    Session(SessionFactory sessionFactory, ExceptionMapper exceptionMapper) {
        assert (sessionFactory != null) : "sessionFactory != null";
        assert (exceptionMapper != null) : "exceptionMapper != null";
        this.sessionFactory = sessionFactory;
        this.hibernateSession = sessionFactory.openSession();
        this.exceptionMapper = exceptionMapper;
    }

    Session(org.hibernate.Session session, ExceptionMapper exceptionMapper) {
        assert (session != null) : "session != null";
        assert (exceptionMapper != null) : "exceptionMapper != null";
        this.hibernateSession = session;
        this.exceptionMapper = exceptionMapper;
    }

    public synchronized void release() {
        if (this.hibernateSession != null) {
            this.hibernateSession.close();
            tlsSession.remove();
        }
        this.hibernateSession = null;
    }

    public IUnitOfWork acquireUnitOfWork() {
        assert (this.hibernateSession != null) : "hibernateSession != null";
        UnitOfWork result = new UnitOfWork(this.sessionFactory, this.exceptionMapper);
        result.begin();
        return result;
    }

    public IQuery getNamedQuery(String queryName) {
        assert (this.hibernateSession != null) : "hibernateSession != null";
        assert (queryName != null) : "queryName != null";
        return new Query(this.hibernateSession.getNamedQuery(queryName));
    }

    public <T extends IModelObject> T load(Class<T> clazz, Serializable id) {
        return (T)((IModelObject)this.hibernateSession.load(clazz, id));
    }

    public <T extends IModelObject> T get(Class<T> clazz, Serializable id) {
        return (T)((IModelObject)this.hibernateSession.get(clazz, id));
    }

    public IQuery createQuery(String queryString) {
        return new Query(this.hibernateSession.createQuery(queryString));
    }

    public List executeQuery(String query, Map<String, Object> parameters) {
        org.hibernate.Query q = this.hibernateSession.createQuery(query);
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                q.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return q.list();
    }

    public int executeUpdate(String update, Map<String, Object> parameters) {
        org.hibernate.Query q = this.hibernateSession.createQuery(update);
        if (parameters != null) {
            for (Map.Entry<String, Object> entry : parameters.entrySet()) {
                q.setParameter(entry.getKey(), entry.getValue());
            }
        }
        return q.executeUpdate();
    }

    public void invalidateObject(IAsset asset) {
        this.hibernateSession.evict((Object)asset);
    }
}

