/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.persistence;

import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.drive.data.internal.model.Sequence;
import com.adobe.drive.data.internal.persistence.ExceptionMapper;
import com.adobe.drive.data.internal.persistence.PersistenceHookDispatcher;
import com.adobe.drive.data.internal.persistence.PersistenceInitializer;
import com.adobe.drive.data.internal.persistence.PersistenceModificationCallable;
import com.adobe.drive.data.internal.persistence.Session;
import com.adobe.drive.data.internal.persistence.UnitOfWork;
import com.adobe.drive.data.model.ISequence;
import com.adobe.drive.data.model.SequenceEnum;
import com.adobe.drive.data.persistence.IDatabase;
import com.adobe.drive.data.persistence.api.IPersistenceCallable;
import com.adobe.drive.data.persistence.api.IPersistenceRunnable;
import com.adobe.drive.data.persistence.api.IPersistenceService;
import com.adobe.drive.data.persistence.api.ISession;
import com.adobe.drive.data.persistence.api.IUnitOfWork;
import com.adobe.drive.data.persistence.factories.SequenceManager;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.StringTokenizer;
import org.hibernate.MappingException;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.Configuration;
import org.hibernate.event.DeleteEventListener;
import org.hibernate.event.def.DefaultDeleteEventListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistenceService
implements IPersistenceService {
    private static final Logger LOGGER = Logger.getLogger(PersistenceService.class);
    private static final String HIBERNATE_MAPPING = "Hibernate-Mapping";
    private static final int RETRY_COUNT = 3;
    private static final int PREALLOCATION_SIZE = 500;
    private static ThreadLocal<Integer> tlsRetryCount = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return new Integer(3);
        }
    };
    private Configuration configuration;
    private SessionFactory sessionFactory;
    private ExceptionMapper exceptionMapper = new ExceptionMapper();
    private ComponentContext context;

    public PersistenceService() {
        com.adobe.drive.data.internal.model.SequenceManager.setInstance((com.adobe.drive.data.internal.model.SequenceManager)new SequenceManager(this));
    }

    public void run(IPersistenceRunnable runnable) throws InvocationTargetException {
        if (runnable == null) {
            throw new IllegalArgumentException("runnable == null");
        }
        IPersistenceCallable<Object> callable = PersistenceService.wrap(runnable);
        this.run(callable);
    }

    /*
     * Exception decompiling
     */
    public <V> V run(IPersistenceCallable<V> callable) throws InvocationTargetException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void runWithTransaction(IPersistenceRunnable runnable) throws InvocationTargetException {
        IPersistenceCallable<Object> callable = PersistenceService.wrap(runnable);
        this.runWithTransaction(callable);
    }

    public <V> V runWithTransaction(final IPersistenceCallable<V> callable) throws InvocationTargetException {
        return this.run(new PersistenceModificationCallable<V>(this){

            @Override
            protected V runWithTransaction() throws InvocationTargetException {
                return callable.run();
            }

            public void onRetry(int retryCount) throws InvocationTargetException {
                callable.onRetry(retryCount);
            }
        });
    }

    public boolean hasSession() {
        return Session.hasSession();
    }

    public ISession createSession() {
        return Session.createSession(this.getSessionFactory(), this.exceptionMapper);
    }

    public ISession currentSession() {
        return Session.currentSession();
    }

    public IUnitOfWork currentUnitOfWork() {
        if (UnitOfWork.hasUnitOfWork()) {
            return UnitOfWork.currentUnitOfWork();
        }
        return null;
    }

    public ISequence createSequence(SequenceEnum sequenceEnum) {
        Sequence sequence = null;
        org.hibernate.classic.Session hibernateSession = this.getSessionFactory().openSession();
        try {
            Transaction tx = hibernateSession.beginTransaction();
            try {
                sequence = (Sequence)hibernateSession.get(Sequence.class, (Serializable)((Object)sequenceEnum.name()));
                if (sequence == null) {
                    sequence = new Sequence(sequenceEnum);
                }
                sequence.setCurrent(sequence.getBound());
                sequence.setBound(sequence.getBound() + 500);
                hibernateSession.saveOrUpdate((Object)sequence);
                tx.commit();
            }
            catch (Exception e) {
                LOGGER.fatal((Object)"Failed to allocate sequence", (Throwable)e);
                tx.rollback();
            }
        }
        finally {
            hibernateSession.close();
        }
        return sequence;
    }

    public int getNextSequenceNumber(ISequence sequence) {
        if (sequence.getCurrent() == sequence.getBound()) {
            this.allocateSequenceNumbers(sequence);
        }
        return sequence.setCurrent(sequence.getCurrent() + 1);
    }

    protected void activate(ComponentContext context) {
        this.context = context;
    }

    protected void deactivate(ComponentContext context) {
        this.getSessionFactory().close();
    }

    private void allocateSequenceNumbers(ISequence sequence) {
        org.hibernate.classic.Session hibernateSession = this.getSessionFactory().openSession();
        try {
            Transaction tx = hibernateSession.beginTransaction();
            try {
                sequence.setCurrent(sequence.getBound());
                sequence.setBound(sequence.getBound() + 500);
                hibernateSession.saveOrUpdate((Object)sequence);
                tx.commit();
            }
            catch (Exception e) {
                LOGGER.fatal((Object)"Failed to allocate sequence", (Throwable)e);
                tx.rollback();
            }
        }
        finally {
            hibernateSession.close();
        }
    }

    private void startUpDatabase(ComponentContext context) {
        block10: {
            Bundle[] bundles;
            IDatabase database = (IDatabase)context.locateService("DATABASE");
            database.initializeSchema();
            Dictionary compProperties = context.getProperties();
            this.configuration = this.createConfiguration(compProperties, database);
            BundleContext bundleContext = context.getBundleContext();
            Bundle[] bundleArray = bundles = bundleContext.getBundles();
            int n = bundles.length;
            int n2 = 0;
            while (n2 < n) {
                Bundle bundle = bundleArray[n2];
                Dictionary headers = bundle.getHeaders();
                String header = (String)headers.get(HIBERNATE_MAPPING);
                if (header != null) {
                    StringTokenizer tokenizer = new StringTokenizer(header, ",");
                    while (tokenizer.hasMoreElements()) {
                        String resourceName = (String)tokenizer.nextElement();
                        URL resource = bundle.getResource(resourceName);
                        if (resource == null && LOGGER.isLogging(Level.WARN)) {
                            LOGGER.warn((Object)("{activate} Mapping not found: '" + resourceName + "' in bundle '" + bundle.getSymbolicName() + "'"));
                        }
                        if (resource == null) continue;
                        try {
                            if (LOGGER.isLogging(Level.TRACE)) {
                                LOGGER.trace((Object)("{activate} Adding mapping '" + resourceName + "' from bundle '" + bundle.getSymbolicName() + "'"));
                            }
                            this.configuration.addInputStream(resource.openStream());
                        }
                        catch (MappingException e) {
                            LOGGER.error((Object)"{activate} Caugt exception", (Throwable)e);
                        }
                        catch (IOException e) {
                            LOGGER.error((Object)"{activate} Caugt exception", (Throwable)e);
                        }
                    }
                }
                ++n2;
            }
            try {
                PersistenceInitializer.initialize(this);
            }
            catch (Exception e) {
                if (!LOGGER.isLogging(Level.ERROR)) break block10;
                LOGGER.error((Object)("Error while initializing the database: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private synchronized SessionFactory getSessionFactory() {
        if (this.sessionFactory == null) {
            this.sessionFactory = this.getConfiguration().buildSessionFactory();
        }
        return this.sessionFactory;
    }

    private synchronized Configuration getConfiguration() {
        if (this.configuration == null) {
            this.startUpDatabase(this.context);
        }
        return this.configuration;
    }

    private Configuration createConfiguration(Dictionary<String, ?> properties, IDatabase database) {
        Configuration result = new Configuration();
        result.setProperty("hibernate.dialect", database.getHibernateDialect());
        result.setProperty("hibernate.connection.driver_class", database.getJdbcDriverClass());
        result.setProperty("hibernate.connection.url", database.getConnectionUrl());
        result.setProperty("hibernate.connection.username", database.getUsername());
        result.setProperty("hibernate.connection.password", database.getPassword());
        result.setProperty("hibernate.connection.pool_size", "5");
        result.setProperty("hibernate.connection.autocommit", "false");
        Enumeration<String> keys = properties.keys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (!key.startsWith("hibernate.")) continue;
            String value = (String)properties.get(key);
            result.setProperty(key, value);
        }
        DeleteEventListener[] deleteEventListeners = new DeleteEventListener[]{new PersistenceHookDispatcher(), new DefaultDeleteEventListener()};
        result.getEventListeners().setDeleteEventListeners(deleteEventListeners);
        return result;
    }

    private static IPersistenceCallable<Object> wrap(final IPersistenceRunnable r) {
        return new IPersistenceCallable<Object>(){

            public Object run() throws InvocationTargetException {
                r.run();
                return null;
            }

            public void onRetry(int retryCount) throws InvocationTargetException {
                r.onRetry(retryCount);
            }
        };
    }
}

