/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.internal.persistence;

import com.adobe.drive.data.internal.persistence.UnitOfWork;
import com.adobe.drive.data.model.asset.ModelException;
import com.adobe.drive.data.persistence.api.IPersistenceCallable;
import com.adobe.drive.data.persistence.api.IPersistenceService;
import com.adobe.drive.data.persistence.api.ISession;
import com.adobe.drive.data.persistence.api.IUnitOfWork;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceModificationCallable<V>
implements IPersistenceCallable<V> {
    private final IPersistenceService persistenceService;

    public PersistenceModificationCallable(IPersistenceService persistenceService) {
        assert (persistenceService != null) : "persistenceService != null";
        this.persistenceService = persistenceService;
    }

    public V run() throws InvocationTargetException {
        V result;
        boolean hasUnitOfWork = this.hasUnitOfWork();
        ISession session = null;
        IUnitOfWork unitOfWork = null;
        try {
            try {
                session = this.persistenceService.currentSession();
                unitOfWork = this.createUnitOfWork(session, hasUnitOfWork);
                result = this.runWithTransaction();
                unitOfWork = this.checkForUnitOfWorkModification(unitOfWork);
                unitOfWork = this.commitUnitOfWork(unitOfWork, hasUnitOfWork);
            }
            catch (ModelException e) {
                throw new InvocationTargetException(e);
            }
        }
        catch (Throwable throwable) {
            if (UnitOfWork.hasUnitOfWork()) {
                unitOfWork = this.checkForUnitOfWorkModification(unitOfWork);
                unitOfWork = this.releaseUnitOfWork(unitOfWork, hasUnitOfWork);
            }
            throw throwable;
        }
        if (UnitOfWork.hasUnitOfWork()) {
            unitOfWork = this.checkForUnitOfWorkModification(unitOfWork);
            unitOfWork = this.releaseUnitOfWork(unitOfWork, hasUnitOfWork);
        }
        return result;
    }

    protected abstract V runWithTransaction() throws InvocationTargetException;

    protected IUnitOfWork createUnitOfWork(ISession session, boolean hasUnitOfWork) {
        assert (session != null) : "session != null";
        UnitOfWork result = hasUnitOfWork ? UnitOfWork.currentUnitOfWork() : session.acquireUnitOfWork();
        return result;
    }

    protected IUnitOfWork commitUnitOfWork(IUnitOfWork unitOfWork, boolean hasUnitOfWork) throws ModelException {
        assert (unitOfWork != null) : "unitOfWork != null";
        if (!hasUnitOfWork) {
            unitOfWork.commit();
        }
        return null;
    }

    protected IUnitOfWork releaseUnitOfWork(IUnitOfWork unitOfWork, boolean hasUnitOfWork) {
        if (!hasUnitOfWork && unitOfWork != null) {
            unitOfWork.rollback();
        }
        return null;
    }

    private IUnitOfWork checkForUnitOfWorkModification(IUnitOfWork unitOfWork) {
        IUnitOfWork currentUnitOfWork = unitOfWork;
        try {
            currentUnitOfWork = UnitOfWork.currentUnitOfWork();
            if (unitOfWork != currentUnitOfWork) {
                unitOfWork.rollback();
            }
        }
        catch (Exception exception) {
        }
        catch (Error error) {}
        return currentUnitOfWork;
    }

    private boolean hasUnitOfWork() {
        return UnitOfWork.hasUnitOfWork();
    }
}

