/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.persistence.api;

import com.adobe.drive.data.model.DriveException;
import com.adobe.drive.data.model.ErrorCodeEnum;
import com.adobe.drive.data.persistence.api.IPersistenceService;
import com.adobe.drive.data.persistence.api.PersistenceRunnableAdapter;
import java.lang.reflect.InvocationTargetException;

public abstract class PersistenceRunner {
    public void run(IPersistenceService persistenceService, ErrorCodeEnum errorCode, boolean transactional) throws DriveException {
        PersistenceRunnableAdapter runnable = new PersistenceRunnableAdapter(){

            public void run() throws InvocationTargetException {
                try {
                    PersistenceRunner.this.work();
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t);
                }
            }
        };
        try {
            if (transactional) {
                persistenceService.runWithTransaction(runnable);
            } else {
                persistenceService.run(runnable);
            }
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DriveException) {
                throw (DriveException)cause;
            }
            throw new DriveException(errorCode, cause);
        }
    }

    public void run(IPersistenceService persistenceService, ErrorCodeEnum errorCode) throws DriveException {
        this.run(persistenceService, errorCode, true);
    }

    protected abstract void work() throws Throwable;
}

