/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.drive.data.persistence.api;

import com.adobe.drive.data.model.DriveException;
import com.adobe.drive.data.model.ErrorCodeEnum;
import com.adobe.drive.data.persistence.api.IPersistenceService;
import com.adobe.drive.data.persistence.api.PersistenceCallableAdapter;
import java.lang.reflect.InvocationTargetException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistenceCaller<V> {
    public V run(IPersistenceService persistenceService, ErrorCodeEnum errorCode, boolean transactional) throws DriveException {
        PersistenceCallableAdapter callable = new PersistenceCallableAdapter<V>(){

            @Override
            public V run() throws InvocationTargetException {
                try {
                    return PersistenceCaller.this.work();
                }
                catch (Throwable t) {
                    throw new InvocationTargetException(t);
                }
            }
        };
        try {
            if (transactional) {
                return persistenceService.runWithTransaction(callable);
            }
            return persistenceService.run(callable);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof DriveException) {
                throw (DriveException)cause;
            }
            throw new DriveException(errorCode, cause);
        }
    }

    public V run(IPersistenceService persistenceService, ErrorCodeEnum errorCode) throws DriveException {
        return this.run(persistenceService, errorCode, true);
    }

    protected abstract V work() throws Throwable;
}

