/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

public class ByteArrayWrapper {
    public byte[] bytes;
    public int size;

    public void ensureCapacity(int capacity) {
        if (this.bytes == null || this.bytes.length < capacity) {
            byte[] newbytes = new byte[capacity];
            ByteArrayWrapper.copyBytes(this.bytes, 0, newbytes, 0, this.size);
            this.bytes = newbytes;
        }
    }

    public final void set(byte[] src, int start, int limit) {
        this.size = 0;
        this.append(src, start, limit);
    }

    public final void append(byte[] src, int start, int limit) {
        int len = limit - start;
        this.ensureCapacity(this.size + len);
        ByteArrayWrapper.copyBytes(src, start, this.bytes, this.size, len);
        this.size += len;
    }

    public final byte[] releaseBytes() {
        byte[] result = this.bytes;
        this.bytes = null;
        this.size = 0;
        return result;
    }

    private static final void copyBytes(byte[] src, int srcoff, byte[] tgt, int tgtoff, int length) {
        if (length < 64) {
            int i = srcoff;
            int n = tgtoff;
            while (--length >= 0) {
                tgt[n] = src[i];
                ++i;
                ++n;
            }
        } else {
            System.arraycopy(src, srcoff, tgt, tgtoff, length);
        }
    }
}

