/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.impl;

import com.ibm.icu.impl.ICUDebug;
import com.ibm.icu.impl.ICUListResourceBundle;
import com.ibm.icu.impl.LocaleUtility;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ICULocaleData {
    private static Locale[] localeList;
    private static final String PACKAGE1 = "com.ibm.icu.impl.data";
    private static final String[] packageNames;
    private static boolean debug;
    private static SoftReference lcacheref;
    public static final String LOCALE_ELEMENTS = "LocaleElements";
    private static SoftReference gBundleCache;
    static /* synthetic */ Class class$com$ibm$icu$impl$ICULocaleData;
    static /* synthetic */ Class class$com$ibm$icu$impl$ICUListResourceBundle;

    public static Locale[] getAvailableLocales(String bundlePrefix) {
        return (Locale[])ICULocaleData.getAvailEntry(bundlePrefix).getLocaleList().clone();
    }

    public static Locale[] getAvailableLocales() {
        return ICULocaleData.getAvailableLocales(LOCALE_ELEMENTS);
    }

    public static Set getAvailableLocaleNameSet(String bundlePrefix) {
        return ICULocaleData.getAvailEntry(bundlePrefix).getLocaleNameSet();
    }

    public static Set getAvailableLocaleNameSet() {
        return ICULocaleData.getAvailableLocaleNameSet(LOCALE_ELEMENTS);
    }

    private static AvailEntry getAvailEntry(String key) {
        AvailEntry ae = null;
        HashMap<String, AvailEntry> lcache = null;
        if (lcacheref != null && (lcache = (HashMap<String, AvailEntry>)lcacheref.get()) != null) {
            ae = (AvailEntry)lcache.get(key);
        }
        if (ae == null) {
            ae = new AvailEntry(key);
            if (lcache == null) {
                lcache = new HashMap<String, AvailEntry>();
                lcache.put(key, ae);
                lcacheref = new SoftReference(lcache);
            } else {
                lcache.put(key, ae);
            }
        }
        return ae;
    }

    public static ResourceBundle getLocaleElements(Locale locale) {
        return ICULocaleData.getResourceBundle(LOCALE_ELEMENTS, locale);
    }

    public static ResourceBundle getLocaleElements(String localeName) {
        return ICULocaleData.getResourceBundle(LOCALE_ELEMENTS, localeName);
    }

    private static ResourceBundle loadFromCache(String key) {
        Map m;
        if (gBundleCache != null && (m = (Map)gBundleCache.get()) != null) {
            return (ResourceBundle)m.get(key);
        }
        return null;
    }

    private static void addToCache(String key, ResourceBundle b) {
        HashMap<String, ResourceBundle> m = null;
        if (gBundleCache != null) {
            m = (HashMap<String, ResourceBundle>)gBundleCache.get();
        }
        if (m == null) {
            m = new HashMap<String, ResourceBundle>();
            gBundleCache = new SoftReference(m);
        }
        m.put(key, b);
    }

    private static ResourceBundle instantiate(String name) {
        ResourceBundle b = ICULocaleData.loadFromCache(name);
        if (b == null) {
            ResourceBundle parent = null;
            int i = name.lastIndexOf(95);
            Locale rootLocale = new Locale("", "", "");
            if (i != -1) {
                parent = ICULocaleData.instantiate(name.substring(0, i));
            }
            try {
                Locale locale = rootLocale;
                i = name.indexOf(95);
                if (i != -1) {
                    locale = LocaleUtility.getLocaleFromName(name.substring(i + 1));
                } else {
                    i = name.length();
                }
                Class<?> cls = (class$com$ibm$icu$impl$ICULocaleData == null ? (class$com$ibm$icu$impl$ICULocaleData = ICULocaleData.class$("com.ibm.icu.impl.ICULocaleData")) : class$com$ibm$icu$impl$ICULocaleData).getClassLoader().loadClass(name);
                if ((class$com$ibm$icu$impl$ICUListResourceBundle == null ? (class$com$ibm$icu$impl$ICUListResourceBundle = ICULocaleData.class$("com.ibm.icu.impl.ICUListResourceBundle")) : class$com$ibm$icu$impl$ICUListResourceBundle).isAssignableFrom(cls)) {
                    ICUListResourceBundle bx = (ICUListResourceBundle)cls.newInstance();
                    if (parent != null) {
                        bx.setParentX(parent);
                    }
                    bx.icuLocale = locale;
                    b = bx;
                } else {
                    b = ResourceBundle.getBundle(name.substring(0, i), locale);
                }
                ICULocaleData.addToCache(name, b);
            }
            catch (ClassNotFoundException e) {
                int j = name.indexOf(95);
                int k = name.lastIndexOf(95);
                if (k == j && j != -1) {
                    String locName = name.substring(j + 1, name.length());
                    String defaultName = Locale.getDefault().toString();
                    if (!locName.equals(rootLocale.toString()) && defaultName.indexOf(locName) == -1) {
                        String bundle = name.substring(0, j);
                        parent = ICULocaleData.instantiate(bundle + "_" + defaultName);
                    }
                }
                b = parent;
            }
            catch (Exception e) {
                System.out.println("failure");
                System.out.println(e);
            }
        }
        return b;
    }

    private static synchronized ResourceBundle instantiateBundle(String name, Locale l) {
        String s = l.toString();
        if (s.length() != 0) {
            return ICULocaleData.instantiate(name + "_" + l);
        }
        return ICULocaleData.instantiate(name);
    }

    public static ResourceBundle getResourceBundle(String bundleName, String localeName) {
        Locale locale = LocaleUtility.getLocaleFromName(localeName);
        return ICULocaleData.getResourceBundle(bundleName, locale);
    }

    public static ResourceBundle getResourceBundle(String bundleName, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        int i = 0;
        if (i < packageNames.length) {
            try {
                String path = packageNames[i] + "." + bundleName;
                if (debug) {
                    System.out.println("calling instantiateBundle: " + path + "_" + locale);
                }
                ResourceBundle rb = ICULocaleData.instantiateBundle(path, locale);
                return rb;
            }
            catch (MissingResourceException e) {
                if (debug) {
                    System.out.println(bundleName + "_" + locale + " not found in " + packageNames[i]);
                }
                throw e;
            }
        }
        return null;
    }

    public static ResourceBundle getResourceBundle(String[] packages, String bundleName, String localeName) {
        Locale locale = LocaleUtility.getLocaleFromName(localeName);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        int i = 0;
        if (i < packages.length) {
            try {
                String path = packages[i] + "." + bundleName;
                if (debug) {
                    System.out.println("calling instantiateBundle: " + path + "_" + locale);
                }
                ResourceBundle rb = ICULocaleData.instantiateBundle(path, locale);
                return rb;
            }
            catch (MissingResourceException e) {
                if (debug) {
                    System.out.println(bundleName + "_" + locale + " not found in " + packages[i]);
                }
                throw e;
            }
        }
        return null;
    }

    public static ResourceBundle getResourceBundle(String packageName, String bundleName, String localeName) {
        Locale locale = LocaleUtility.getLocaleFromName(localeName);
        if (locale == null) {
            locale = Locale.getDefault();
        }
        try {
            String path = packageName + "." + bundleName;
            if (debug) {
                System.out.println("calling instantiateBundle: " + path + "_" + locale);
            }
            ResourceBundle rb = ICULocaleData.instantiateBundle(path, locale);
            return rb;
        }
        catch (MissingResourceException e) {
            if (debug) {
                System.out.println(bundleName + "_" + locale + " not found in " + packageName);
            }
            throw e;
        }
    }

    public static ResourceBundle loadResourceBundle(String bundleName, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ICULocaleData.loadResourceBundle(bundleName, locale.toString());
    }

    public static ResourceBundle loadResourceBundle(String bundleName, String localeName) {
        if (localeName != null && localeName.length() > 0) {
            bundleName = bundleName + "_" + localeName;
        }
        int i = 0;
        while (i < packageNames.length) {
            block8: {
                String name = packageNames[i] + "." + bundleName;
                try {
                    if (name.indexOf("_zh_") == -1) {
                        Class<?> rbclass = Class.forName(name);
                        ResourceBundle rb = (ResourceBundle)rbclass.newInstance();
                        return rb;
                    }
                }
                catch (ClassNotFoundException e) {
                    if (debug) {
                        System.out.println(bundleName + " not found in " + packageNames[i]);
                    }
                }
                catch (Exception e) {
                    if (!debug) break block8;
                    System.out.println(e.getMessage());
                }
            }
            ++i;
        }
        if (debug) {
            System.out.println(bundleName + " not found.");
        }
        return null;
    }

    private static Set createLocaleNameSet(String bundleName) {
        try {
            ResourceBundle index = ICULocaleData.getResourceBundle(bundleName, "index");
            Object[][] localeStrings = (Object[][])index.getObject("InstalledLocales");
            String[] localeNames = new String[localeStrings.length];
            int i = 0;
            while (i < localeNames.length) {
                localeNames[i] = LocaleUtility.getLocaleFromName((String)localeStrings[i][0]).toString();
                ++i;
            }
            HashSet<String> set = new HashSet<String>();
            set.addAll(Arrays.asList(localeNames));
            return Collections.unmodifiableSet(set);
        }
        catch (MissingResourceException e) {
            System.out.println("couldn't find index for bundleName: " + bundleName);
            Thread.dumpStack();
            return Collections.EMPTY_SET;
        }
    }

    private static Locale[] createLocaleList(String bundleName) {
        try {
            ResourceBundle index = ICULocaleData.getResourceBundle(bundleName, "index");
            Object[][] localeStrings = (Object[][])index.getObject("InstalledLocales");
            Locale[] locales = new Locale[localeStrings.length];
            int i = 0;
            while (i < localeStrings.length) {
                locales[i] = LocaleUtility.getLocaleFromName((String)localeStrings[i][0]);
                ++i;
            }
            return locales;
        }
        catch (MissingResourceException e) {
            System.out.println("couldn't find index for bundleName: " + bundleName);
            Thread.dumpStack();
            return new Locale[0];
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        packageNames = new String[]{PACKAGE1};
        debug = ICUDebug.enabled("localedata");
    }

    private static final class AvailEntry {
        private String prefix;
        private Locale[] locales;
        private Set nameSet;

        AvailEntry(String prefix) {
            this.prefix = prefix;
        }

        Locale[] getLocaleList() {
            if (this.locales == null) {
                this.locales = ICULocaleData.createLocaleList(this.prefix);
            }
            return this.locales;
        }

        Set getLocaleNameSet() {
            if (this.nameSet == null) {
                this.nameSet = ICULocaleData.createLocaleNameSet(this.prefix);
            }
            return this.nameSet;
        }
    }
}

