/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.discovery.servlets;

import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.core.ServiceRegistryException;
import com.adobe.csi.internal.discovery.WebAppComponent;
import java.io.IOException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DiscoveryServlet
extends HttpServlet {
    private static final long serialVersionUID = -4102697106252941744L;
    private final WebAppComponent webAppComponent;

    public DiscoveryServlet(WebAppComponent webAppComponent) {
        this.webAppComponent = webAppComponent;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        IServiceRegistry serviceRegistry = this.webAppComponent.getServiceRegistry();
        if (serviceRegistry != null) {
            try {
                String manifest = serviceRegistry.getManifestXML();
                resp.setCharacterEncoding("UTF-8");
                resp.setContentType("text/xml");
                resp.getWriter().write(manifest);
            }
            catch (ServiceRegistryException e) {
                resp.sendError(500, e.getMessage());
            }
        } else {
            resp.sendError(500, "ServiceRegistry is unavailable");
        }
    }
}

