/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.discovery;

import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.internal.discovery.WebAppContext;
import com.adobe.csi.internal.discovery.servlets.DiscoveryServlet;
import java.util.Hashtable;
import javax.servlet.Servlet;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

public class WebAppComponent {
    private static final String PROP_DISCOVERY_SERVLET_ALIAS = "com.adobe.csi.discovery.servlet.alias";
    private WebAppContext httpContext;
    private HttpService httpService;
    private IServiceRegistry serviceRegistry;

    public IServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    protected void activate(ComponentContext context) throws Exception {
        this.httpContext = new WebAppContext();
        String discoveryAlias = (String)context.getProperties().get(PROP_DISCOVERY_SERVLET_ALIAS);
        this.httpService.registerServlet(discoveryAlias, (Servlet)new DiscoveryServlet(this), new Hashtable(), (HttpContext)this.httpContext);
    }

    protected void bindHttpService(HttpService httpService) {
        this.httpService = httpService;
    }

    protected void bindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected void deactivate(ComponentContext context) {
        String discoveryAlias = (String)context.getProperties().get(PROP_DISCOVERY_SERVLET_ALIAS);
        this.httpService.unregister(discoveryAlias);
        this.httpContext = null;
    }

    protected void unbindHttpService(HttpService httpService) {
        this.httpService = null;
    }

    protected void unbindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = null;
    }
}

