/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.discovery;

import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.discovery.IResourceCacheManager;
import com.adobe.csi.discovery.ResourceException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.osgi.service.component.ComponentContext;

public class ResourceCacheManager
implements IResourceCacheManager {
    private static final Logger LOGGER = Logger.getLogger(ResourceCacheManager.class);
    private static final String PROP_RESOURCE_CACHE_ROOT_DIR = "com.adobe.csi.discovery.resource.cache.dir";
    private String rootDir;

    public void readResource(String resource, OutputStream outputStream) throws ResourceException, IOException {
        try {
            URL url = new URL(resource);
            this.readResource(url, outputStream);
        }
        catch (MalformedURLException malformedURLException) {
            throw new ResourceException("Invalid URL: " + resource, ResourceException.ErrorCode.INVALID_RESOURCE);
        }
    }

    public synchronized void readResource(URL resource, OutputStream outputStream) throws ResourceException, IOException {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Requesting resource: " + resource));
        }
        String urlPath = resource.getPath();
        urlPath = URLDecoder.decode(urlPath, "UTF-8");
        int index = (urlPath = this.maskInvalidChars(urlPath)).lastIndexOf("/");
        if (index <= 0 || index == urlPath.length() - 1) {
            throw new ResourceException("Not a valid file: " + resource, ResourceException.ErrorCode.INVALID_RESOURCE);
        }
        String tmpPath = urlPath.substring(0, index + 1);
        String tmpFile = urlPath.substring(index + 1);
        File path = new File(String.valueOf(this.rootDir) + "/" + tmpPath);
        File file = new File(path, tmpFile);
        if (!file.exists()) {
            path.mkdirs();
            this.transferContent(resource.openStream(), new FileOutputStream(file));
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Resource downloaded from: " + resource));
            }
        }
        if (!file.isFile()) {
            throw new ResourceException("Not a valid file: " + urlPath, ResourceException.ErrorCode.INVALID_RESOURCE);
        }
        this.transferContent(new FileInputStream(file), outputStream);
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Resource transfered: " + resource));
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        boolean mkDirs;
        File file;
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating IResourceCacheManager: " + ResourceCacheManager.class));
        }
        this.rootDir = (String)context.getProperties().get(PROP_RESOURCE_CACHE_ROOT_DIR);
        if (this.rootDir == null || this.rootDir.trim().equals("")) {
            this.rootDir = String.valueOf(System.getProperty("java.io.tmpdir")) + "/adobe/csi/discovery/cache/";
        }
        if (!(file = new File(this.rootDir)).exists() && !(mkDirs = file.mkdirs())) {
            throw new Exception("Directory could not be created: " + this.rootDir);
        }
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Files will be cached under: " + this.rootDir));
        }
    }

    protected void deactivate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deactivating IResourceCacheManager: " + ResourceCacheManager.class));
        }
        this.rootDir = null;
    }

    private String maskInvalidChars(String path) {
        String maskedPath = path;
        maskedPath = maskedPath.replaceAll(":", "__");
        return maskedPath;
    }

    private void transferContent(InputStream inputStream, OutputStream outputStream) throws IOException {
        BufferedInputStream bis = null;
        BufferedOutputStream bos = null;
        try {
            bis = new BufferedInputStream(inputStream);
            bos = new BufferedOutputStream(outputStream);
            int length = 0;
            byte[] bytes = new byte[2048];
            while ((length = bis.read(bytes)) > 0) {
                bos.write(bytes, 0, length);
            }
        }
        catch (Throwable throwable) {
            try {
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (bos != null) {
                    bos.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (bis != null) {
                bis.close();
            }
        }
        catch (IOException iOException) {}
        try {
            if (bos != null) {
                bos.close();
            }
        }
        catch (IOException iOException) {}
    }
}

