/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import com.sun.deploy.config.Config;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.JarFile;
import sun.plugin.cache.Cache;
import sun.plugin.cache.CachedJarFile;
import sun.plugin.cache.CachedJarLoader;
import sun.plugin.cache.FileCache;
import sun.plugin.cache.FileVersion;
import sun.plugin.cache.JarCacheVersionException;
import sun.plugin.util.UserProfile;

public class JarCache {
    protected static File directory;
    protected static int compression;
    protected static Hashtable loadedJars;
    protected static Hashtable currentJars;
    protected static Hashtable jarVersions;
    protected static long lastCacheModifyTime;
    protected static Hashtable filesInCache;
    protected static ReferenceQueue refQueue;
    protected static final String DATA_FILE_EXT = ".zip";
    protected static final String JAR_FILE_EXT = ".jar";
    protected static final String JARJAR_FILE_EXT = ".jarjar";
    protected static final String META_FILE_DIR = "meta-inf/";
    protected static final String COMPRESSION_PROP = "javaplugin.cache.compression";

    public static void init() {
    }

    public static JarFile get(URL uRL) throws IOException {
        CachedJarFile cachedJarFile = null;
        if (Cache.cachingDisabled) {
            return null;
        }
        if (JarCache.isSupported(uRL)) {
            try {
                Cache.checkPermission(uRL.openConnection());
            }
            catch (IOException iOException) {
                return null;
            }
            JarReference jarReference = (JarReference)loadedJars.get(uRL);
            if (jarReference != null) {
                cachedJarFile = (CachedJarFile)jarReference.get();
            }
            if (cachedJarFile == null) {
                CachedJarLoader cachedJarLoader = (CachedJarLoader)currentJars.remove(uRL);
                if (cachedJarLoader == null) {
                    cachedJarLoader = new CachedJarLoader(uRL, false);
                    FileVersion fileVersion = (FileVersion)jarVersions.get(uRL);
                    if (fileVersion != null && !cachedJarLoader.isVersionUpToDate(fileVersion)) {
                        cachedJarLoader.setVersion(fileVersion);
                    }
                }
                cachedJarFile = cachedJarLoader.load();
                loadedJars.put(uRL, new JarReference(cachedJarFile, refQueue, uRL));
                while ((jarReference = (JarReference)refQueue.poll()) != null) {
                    loadedJars.remove(jarReference.getURL());
                }
            }
        }
        return cachedJarFile;
    }

    protected static final boolean isSupported(URL uRL) {
        return Cache.isSupportedProtocol(uRL);
    }

    protected static long getJarSize(URL uRL) throws IOException {
        long l = -1L;
        if (JarCache.isSupported(uRL)) {
            if (Cache.cachingDisabled) {
                l = Cache.getFileSizeFromServer(uRL);
            } else {
                CachedJarLoader cachedJarLoader = new CachedJarLoader(uRL, true);
                l = cachedJarLoader.getJarSize();
                currentJars.put(uRL, cachedJarLoader);
            }
        }
        return l;
    }

    protected static boolean handleVersion(URL uRL, FileVersion fileVersion) throws IOException {
        boolean bl = false;
        if (JarCache.isSupported(uRL) && !Cache.cachingDisabled) {
            jarVersions.put(uRL, fileVersion);
            CachedJarLoader cachedJarLoader = new CachedJarLoader(uRL, false);
            JarReference jarReference = (JarReference)loadedJars.get(uRL);
            if (!cachedJarLoader.isVersionUpToDate(fileVersion)) {
                cachedJarLoader.setVersion(fileVersion);
                if (jarReference != null) {
                    loadedJars.remove(uRL);
                    bl = true;
                }
                currentJars.put(uRL, cachedJarLoader);
            } else if (jarReference == null) {
                currentJars.put(uRL, cachedJarLoader);
            }
        }
        return bl;
    }

    protected static final File getDataFile(File file) {
        String string = file.getName();
        string = string.substring(0, string.length() - ".idx".length());
        string = string + DATA_FILE_EXT;
        return new File(file.getParentFile(), string);
    }

    protected static String generateCacheFileName(URL uRL) throws IOException {
        return Cache.generateCacheFileName(directory, uRL);
    }

    public static void clearLoadedJars() {
        loadedJars.clear();
        currentJars.clear();
        jarVersions.clear();
        while (refQueue.poll() != null) {
        }
    }

    protected static Enumeration getMatchingFiles(URL uRL) {
        return Cache.getMatchingFiles(directory, uRL);
    }

    protected static boolean getMatchingFile(CachedJarLoader cachedJarLoader) throws IOException {
        boolean bl = false;
        String string = Cache.getKey(cachedJarLoader.getURL());
        bl = JarCache.match(cachedJarLoader, string);
        if (!bl && Cache.updateTable(directory, filesInCache, string)) {
            bl = JarCache.match(cachedJarLoader, string);
        }
        return bl;
    }

    protected static synchronized boolean match(CachedJarLoader cachedJarLoader, String string) throws IOException {
        boolean bl = false;
        ArrayList arrayList = (ArrayList)filesInCache.get(string);
        if (arrayList != null) {
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                File file = (File)iterator.next();
                File file2 = FileCache.getDataFile(file, cachedJarLoader.getURL());
                if (file.exists() && file2.exists()) {
                    bl = JarCache.verifyFile(file, cachedJarLoader);
                } else {
                    iterator.remove();
                    if (arrayList.size() == 0) {
                        filesInCache.remove(string);
                    }
                }
                if (!bl) continue;
                cachedJarLoader.setDataFile(file2);
                break;
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean verifyFile(File file, CachedJarLoader cachedJarLoader) throws IOException {
        boolean bl = false;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        try {
            String string;
            if (randomAccessFile.readByte() == 16 && (string = randomAccessFile.readUTF()).equals(cachedJarLoader.getURL().toString())) {
                bl = true;
                cachedJarLoader.setIndexFile(file);
                cachedJarLoader.setLastModify(randomAccessFile.readLong());
                cachedJarLoader.setExpiration(randomAccessFile.readLong());
                randomAccessFile.readInt();
                String string2 = randomAccessFile.readUTF();
                cachedJarLoader.setVersion(new FileVersion(string2));
            }
        }
        catch (IOException iOException) {
        }
        catch (JarCacheVersionException jarCacheVersionException) {
        }
        finally {
            try {
                randomAccessFile.close();
                randomAccessFile = null;
            }
            catch (IOException iOException) {}
        }
        return bl;
    }

    static {
        loadedJars = new Hashtable();
        currentJars = new Hashtable();
        jarVersions = new Hashtable();
        lastCacheModifyTime = 0L;
        filesInCache = new Hashtable();
        refQueue = new ReferenceQueue();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Cache.init();
                if (!Cache.cachingDisabled) {
                    directory = null;
                    String string = UserProfile.getJarCacheDirectory();
                    if (string != null) {
                        directory = new File(string.trim());
                    }
                    boolean bl = false;
                    if (directory != null) {
                        bl = directory.exists();
                        if (!bl) {
                            bl = directory.mkdirs();
                            if (!bl) {
                                Cache.msgPrintln("cache.create_warning", new Object[]{directory});
                                Cache.cachingDisabled = true;
                            }
                        } else if (!directory.canRead()) {
                            bl = false;
                            Cache.msgPrintln("cache.read_warning", new Object[]{directory});
                        } else if (!directory.canWrite()) {
                            bl = false;
                            Cache.msgPrintln("cache.write_warning", new Object[]{directory});
                        } else if (!directory.isDirectory()) {
                            bl = false;
                            Cache.msgPrintln("cache.directory_warning", new Object[]{directory});
                        }
                    }
                    if (bl) {
                        Cache.createTable(directory, filesInCache);
                        string = Config.getProperty((String)"deployment.cache.jarcompression");
                        string.trim();
                        try {
                            compression = Integer.valueOf(string);
                            if (compression < 0 || compression > 9) {
                                compression = 0;
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            compression = 0;
                        }
                        Cache.msgPrintln("cache.compression", new Object[]{String.valueOf(compression)});
                    }
                }
                return null;
            }
        });
    }

    protected static class JarReference
    extends WeakReference {
        URL url;

        public JarReference(Object object, ReferenceQueue referenceQueue, URL uRL) {
            super(object, referenceQueue);
            this.url = uRL;
        }

        public URL getURL() {
            return this.url;
        }
    }
}

