/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.resolver;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.ds.Activator;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.instance.InstanceProcess;
import org.eclipse.equinox.ds.model.ComponentConfiguration;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.model.ProvideDescription;
import org.eclipse.equinox.ds.model.ReferenceDescription;
import org.eclipse.equinox.ds.resolver.CircularityException;
import org.eclipse.equinox.ds.resolver.Reference;
import org.eclipse.equinox.ds.workqueue.WorkDispatcher;
import org.eclipse.equinox.ds.workqueue.WorkQueue;
import org.osgi.framework.AllServiceListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServicePermission;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.ComponentException;
import org.osgi.util.tracker.ServiceTracker;

public class Resolver
implements AllServiceListener,
WorkDispatcher {
    private static final boolean DEBUG = false;
    private static long componentid;
    public ServiceTracker configAdminTracker;
    private static final int BUILD = 1;
    public static final int DYNAMICBIND = 3;
    private Activator main;
    public InstanceProcess instanceProcess;
    public List enabledComponentConfigurations;
    public List satisfiedComponentConfigurations;
    public Map enabledCDsByName;
    private WorkQueue workQueue;
    static /* synthetic */ Class class$0;

    public Resolver(Activator main) {
        this.main = main;
        componentid = 1L;
        this.workQueue = main.workQueue;
        this.enabledComponentConfigurations = new ArrayList();
        this.satisfiedComponentConfigurations = new ArrayList();
        this.enabledCDsByName = new HashMap();
        BundleContext bundleContext = main.context;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.cm.ConfigurationAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.configAdminTracker = new ServiceTracker(bundleContext, clazz.getName(), null);
        this.configAdminTracker.open();
        this.instanceProcess = new InstanceProcess(main);
        main.context.addServiceListener((ServiceListener)this);
    }

    public void dispose() {
        this.main.context.removeServiceListener((ServiceListener)this);
        this.instanceProcess.dispose();
        this.instanceProcess = null;
        this.configAdminTracker.close();
        this.configAdminTracker = null;
        this.enabledComponentConfigurations = null;
        this.satisfiedComponentConfigurations = null;
        this.enabledCDsByName = null;
    }

    public void enableComponents(List componentDescriptions) throws ComponentException {
        Iterator it = componentDescriptions.iterator();
        while (it.hasNext()) {
            ComponentDescription cd = (ComponentDescription)it.next();
            this.enabledCDsByName.put(cd.getName(), cd);
            Configuration config = null;
            try {
                ConfigurationAdmin configurationAdmin = (ConfigurationAdmin)this.configAdminTracker.getService();
                if (configurationAdmin != null) {
                    config = configurationAdmin.getConfiguration(cd.getName(), cd.getBundleContext().getBundle().getLocation());
                }
            }
            catch (IOException e) {
                Log.log(1, "[SCR] IOException when getting Configuration Properties. ", e);
            }
            if (config == null) {
                this.map(cd, null);
                continue;
            }
            if (config.getFactoryPid() != null) {
                if (cd.getFactory() != null) {
                    throw new ComponentException("incompatible to specify both ComponentFactory and ManagedServiceFactory are incompatible");
                }
                Configuration[] configs = null;
                try {
                    ConfigurationAdmin cm = (ConfigurationAdmin)this.configAdminTracker.getService();
                    configs = cm.listConfigurations("(service.factoryPid=" + config.getFactoryPid() + ")");
                }
                catch (InvalidSyntaxException e) {
                    Log.log(1, "[SCR] InvalidSyntaxException when getting CM Configurations. ", e);
                }
                catch (IOException e) {
                    Log.log(1, "[SCR] IOException when getting CM Configurations. ", e);
                }
                if (configs == null) continue;
                int i = 0;
                while (i < configs.length) {
                    this.map(cd, configs[i].getProperties());
                    ++i;
                }
                continue;
            }
            this.map(cd, config.getProperties());
        }
        this.resolve(null);
    }

    public ComponentConfiguration map(ComponentDescription cd, Dictionary configAdminProps) {
        return this.doMap(cd, configAdminProps, cd.getFactory() != null);
    }

    public ComponentConfiguration mapFactoryInstance(ComponentDescription cd, Dictionary configAdminProps) {
        return this.doMap(cd, configAdminProps, false);
    }

    private ComponentConfiguration doMap(ComponentDescription cd, Dictionary configAdminProps, boolean componentFactory) {
        Hashtable properties = this.initProperties(cd, configAdminProps);
        ArrayList<Reference> references = new ArrayList<Reference>();
        Iterator it = cd.getReferenceDescriptions().iterator();
        while (it.hasNext()) {
            ReferenceDescription referenceDesc = (ReferenceDescription)it.next();
            Reference ref = new Reference(referenceDesc, properties);
            references.add(ref);
        }
        references = !references.isEmpty() ? references : Collections.EMPTY_LIST;
        ComponentConfiguration componentConfiguration = new ComponentConfiguration(cd, references, properties, componentFactory);
        it = componentConfiguration.getReferences().iterator();
        while (it.hasNext()) {
            Reference reference = (Reference)it.next();
            reference.setComponentConfiguration(componentConfiguration);
        }
        cd.addComponentConfiguration(componentConfiguration);
        this.enabledComponentConfigurations.add(componentConfiguration);
        return componentConfiguration;
    }

    private Hashtable initProperties(ComponentDescription cd, Dictionary configAdminProps) {
        List servicesProvided;
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        Iterator it = cd.getReferenceDescriptions().iterator();
        while (it.hasNext()) {
            ReferenceDescription referenceDesc = (ReferenceDescription)it.next();
            if (referenceDesc.getTarget() == null) continue;
            properties.put(String.valueOf(referenceDesc.getName()) + ".target", referenceDesc.getTarget());
        }
        properties.putAll(cd.getProperties());
        if (configAdminProps != null) {
            Enumeration keys = configAdminProps.keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                properties.put((String)key, configAdminProps.get(key));
            }
        }
        properties.put("component.name", cd.getName());
        properties.put("component.id", new Long(this.getNextComponentId()));
        if (cd.getFactory() != null) {
            properties.put("component.factory", cd.getFactory());
        }
        if (!(servicesProvided = cd.getServicesProvided()).isEmpty()) {
            properties.put("objectClass", servicesProvided.toArray(new String[servicesProvided.size()]));
        }
        return properties;
    }

    public void disableComponents(List componentDescriptions) {
        Iterator it = componentDescriptions.iterator();
        while (it.hasNext()) {
            ComponentDescription cd = (ComponentDescription)it.next();
            this.disposeComponentConfigurations((List)((ArrayList)cd.getComponentConfigurations()).clone());
            cd.clearComponentConfigurations();
            this.enabledCDsByName.remove(cd.getName());
        }
    }

    public void disposeComponentConfigurations(List componentConfigurations) {
        this.satisfiedComponentConfigurations.removeAll(componentConfigurations);
        this.enabledComponentConfigurations.removeAll(componentConfigurations);
        this.instanceProcess.disposeComponentConfigurations(componentConfigurations);
    }

    private void resolve(ServiceEvent event) {
        if (event == null) {
            this.resolveCycles();
            List newlySatisfiedComponentConfigurations = this.resolveSatisfied();
            newlySatisfiedComponentConfigurations.removeAll(this.satisfiedComponentConfigurations);
            if (!newlySatisfiedComponentConfigurations.isEmpty()) {
                this.satisfiedComponentConfigurations.addAll(newlySatisfiedComponentConfigurations);
                this.workQueue.enqueueWork(this, 1, newlySatisfiedComponentConfigurations);
            }
        } else if (event.getType() == 1) {
            List dynamicBind = this.selectDynamicBind(event.getServiceReference());
            if (!dynamicBind.isEmpty()) {
                this.workQueue.enqueueWork(this, 3, dynamicBind);
            }
            List newlySatisfiedComponentConfigurations = this.resolveSatisfied();
            newlySatisfiedComponentConfigurations.removeAll(this.satisfiedComponentConfigurations);
            if (!newlySatisfiedComponentConfigurations.isEmpty()) {
                this.satisfiedComponentConfigurations.addAll(newlySatisfiedComponentConfigurations);
                this.workQueue.enqueueWork(this, 1, newlySatisfiedComponentConfigurations);
            }
        } else if (event.getType() == 2) {
            List dynamicBind;
            Map dynamicUnBind;
            List newlyUnsatisfiedComponentConfigurations = (List)((ArrayList)this.satisfiedComponentConfigurations).clone();
            newlyUnsatisfiedComponentConfigurations.removeAll(this.resolveSatisfied());
            if (!newlyUnsatisfiedComponentConfigurations.isEmpty()) {
                this.satisfiedComponentConfigurations.removeAll(newlyUnsatisfiedComponentConfigurations);
                this.instanceProcess.disposeComponentConfigurations(newlyUnsatisfiedComponentConfigurations);
            }
            if (!(dynamicUnBind = this.selectDynamicUnBind(event.getServiceReference())).isEmpty()) {
                this.instanceProcess.dynamicUnBind(dynamicUnBind);
            }
            if (!(dynamicBind = this.selectDynamicBind(event.getServiceReference())).isEmpty()) {
                this.workQueue.enqueueWork(this, 3, dynamicBind);
            }
            List newlySatisfiedComponentConfigurations = this.resolveSatisfied();
            newlySatisfiedComponentConfigurations.removeAll(this.satisfiedComponentConfigurations);
            if (!newlySatisfiedComponentConfigurations.isEmpty()) {
                this.satisfiedComponentConfigurations.addAll(newlySatisfiedComponentConfigurations);
                this.workQueue.enqueueWork(this, 1, newlySatisfiedComponentConfigurations);
            }
        } else if (event.getType() == 4) {
            Map dynamicUnBind;
            List newlyUnsatisfiedComponentConfigurations = (List)((ArrayList)this.satisfiedComponentConfigurations).clone();
            newlyUnsatisfiedComponentConfigurations.removeAll(this.resolveSatisfied());
            if (!newlyUnsatisfiedComponentConfigurations.isEmpty()) {
                this.satisfiedComponentConfigurations.removeAll(newlyUnsatisfiedComponentConfigurations);
                this.instanceProcess.disposeComponentConfigurations(newlyUnsatisfiedComponentConfigurations);
            }
            if (!(dynamicUnBind = this.selectDynamicUnBind(event.getServiceReference())).isEmpty()) {
                this.instanceProcess.dynamicUnBind(dynamicUnBind);
            }
        }
    }

    public boolean justResolve(ComponentConfiguration componentConfiguration) {
        this.resolveCycles();
        List newlySatisfiedComponentConfigurations = this.resolveSatisfied();
        newlySatisfiedComponentConfigurations.removeAll(this.satisfiedComponentConfigurations);
        if (!newlySatisfiedComponentConfigurations.contains(componentConfiguration)) {
            return false;
        }
        this.satisfiedComponentConfigurations.add(componentConfiguration);
        return true;
    }

    private List resolveSatisfied() {
        ArrayList<ComponentConfiguration> resolvedSatisfiedComponentConfigurations = new ArrayList<ComponentConfiguration>();
        Iterator it = this.enabledComponentConfigurations.iterator();
        while (it.hasNext()) {
            ComponentConfiguration componentConfiguration = (ComponentConfiguration)it.next();
            ComponentDescription cd = componentConfiguration.getComponentDescription();
            List refs = componentConfiguration.getReferences();
            Iterator iterator = refs.iterator();
            boolean hasProviders = true;
            while (iterator.hasNext()) {
                Reference reference = (Reference)iterator.next();
                if (reference == null || !reference.getReferenceDescription().isRequired() || reference.hasProvider(componentConfiguration.getComponentDescription().getBundleContext())) continue;
                hasProviders = false;
                break;
            }
            if (!hasProviders) continue;
            if (cd.getService() != null && System.getSecurityManager() != null) {
                ProvideDescription[] provides = cd.getService().getProvides();
                Bundle bundle = cd.getBundleContext().getBundle();
                boolean hasPermission = true;
                int i = 0;
                while (i < provides.length) {
                    if (!bundle.hasPermission((Object)new ServicePermission(provides[i].getInterfacename(), "register"))) {
                        hasPermission = false;
                        break;
                    }
                    ++i;
                }
                if (!hasPermission) continue;
            }
            resolvedSatisfiedComponentConfigurations.add(componentConfiguration);
        }
        return resolvedSatisfiedComponentConfigurations.isEmpty() ? Collections.EMPTY_LIST : resolvedSatisfiedComponentConfigurations;
    }

    public void serviceChanged(ServiceEvent event) {
        event.getServiceReference();
        int eventType = event.getType();
        switch (eventType) {
            case 1: 
            case 2: 
            case 4: {
                this.resolve(event);
            }
        }
    }

    public void dispatchWork(int workAction, Object workObject) {
        switch (workAction) {
            case 1: {
                List queueComponentConfigurations = (List)workObject;
                ArrayList<ComponentConfiguration> componentConfigurations = new ArrayList<ComponentConfiguration>(queueComponentConfigurations.size());
                Iterator it = queueComponentConfigurations.iterator();
                while (it.hasNext()) {
                    ComponentConfiguration componentConfiguration = (ComponentConfiguration)it.next();
                    if (!this.satisfiedComponentConfigurations.contains(componentConfiguration)) continue;
                    componentConfigurations.add(componentConfiguration);
                }
                if (componentConfigurations.isEmpty()) break;
                this.instanceProcess.registerComponentConfigurations(componentConfigurations);
                break;
            }
            case 3: {
                List references = (List)workObject;
                Iterator it = references.iterator();
                while (it.hasNext()) {
                    if (this.satisfiedComponentConfigurations.contains(((Reference)it.next()).getComponentConfiguration())) continue;
                    it.remove();
                }
                if (references.isEmpty()) break;
                this.instanceProcess.dynamicBind(references);
            }
        }
    }

    private List selectDynamicBind(ServiceReference serviceReference) {
        ArrayList<Reference> bindList = new ArrayList<Reference>();
        Iterator it = this.satisfiedComponentConfigurations.iterator();
        while (it.hasNext()) {
            ComponentConfiguration componentConfiguration = (ComponentConfiguration)it.next();
            List references = componentConfiguration.getReferences();
            Iterator refIt = references.iterator();
            while (refIt.hasNext()) {
                Reference reference = (Reference)refIt.next();
                if (!reference.dynamicBindReference(serviceReference)) continue;
                bindList.add(reference);
            }
        }
        return bindList;
    }

    private Map selectDynamicUnBind(ServiceReference serviceReference) {
        Hashtable<Reference, ServiceReference> unbindJobs = new Hashtable<Reference, ServiceReference>();
        Iterator it = this.satisfiedComponentConfigurations.iterator();
        while (it.hasNext()) {
            ComponentConfiguration componentConfiguration = (ComponentConfiguration)it.next();
            List references = componentConfiguration.getReferences();
            Iterator it_ = references.iterator();
            while (it_.hasNext()) {
                Reference reference = (Reference)it_.next();
                if (!reference.dynamicUnbindReference(serviceReference)) continue;
                unbindJobs.put(reference, serviceReference);
            }
        }
        return unbindJobs.isEmpty() ? Collections.EMPTY_MAP : unbindJobs;
    }

    private void resolveCycles() {
        try {
            Hashtable<ComponentConfiguration, List> dependencies = new Hashtable<ComponentConfiguration, List>();
            Iterator<Object> it = this.enabledComponentConfigurations.iterator();
            while (it.hasNext()) {
                ComponentConfiguration enabledComponentConfiguration = (ComponentConfiguration)it.next();
                ArrayList<ReferenceComponentConfiguration> dependencyList = new ArrayList<ReferenceComponentConfiguration>();
                Iterator refIt = enabledComponentConfiguration.getReferences().iterator();
                while (refIt.hasNext()) {
                    Reference reference = (Reference)refIt.next();
                    ComponentConfiguration providerComponentConfiguration = reference.findProviderComponentConfiguration(this.enabledComponentConfigurations);
                    if (providerComponentConfiguration == null) continue;
                    dependencyList.add(new ReferenceComponentConfiguration(reference, providerComponentConfiguration));
                }
                if (!dependencyList.isEmpty()) {
                    dependencies.put(enabledComponentConfiguration, dependencyList);
                    continue;
                }
                dependencies.put(enabledComponentConfiguration, Collections.EMPTY_LIST);
            }
            HashSet visited = new HashSet();
            it = dependencies.keySet().iterator();
            while (it.hasNext()) {
                ComponentConfiguration componentConfiguration = (ComponentConfiguration)it.next();
                if (visited.contains(componentConfiguration)) continue;
                ArrayList currentStack = new ArrayList();
                this.traverseDependencies(componentConfiguration, visited, dependencies, currentStack);
            }
        }
        catch (CircularityException e) {
            Log.log(1, "[SCR] Circularity Exception.", e);
            this.enabledComponentConfigurations.remove(e.getCircularDependency());
            this.resolveCycles();
        }
    }

    private void traverseDependencies(ComponentConfiguration componentConfiguration, Set visited, Hashtable dependencies, List currentStack) throws CircularityException {
        if (visited.contains(componentConfiguration)) {
            return;
        }
        List refComponentConfigurations = (List)dependencies.get(componentConfiguration);
        Iterator it = refComponentConfigurations.iterator();
        while (it.hasNext()) {
            ReferenceComponentConfiguration refComponentConfiguration = (ReferenceComponentConfiguration)it.next();
            if (currentStack.contains(refComponentConfiguration)) {
                this.handleDependencyCycle(refComponentConfiguration, currentStack);
                return;
            }
            currentStack.add(refComponentConfiguration);
            this.traverseDependencies(refComponentConfiguration.producer, visited, dependencies, currentStack);
            currentStack.remove(refComponentConfiguration);
        }
        visited.add(componentConfiguration);
    }

    private void handleDependencyCycle(ReferenceComponentConfiguration refComponentConfiguration, List currentStack) throws CircularityException {
        ListIterator cycleIterator = currentStack.listIterator(currentStack.indexOf(refComponentConfiguration));
        ReferenceComponentConfiguration optionalRefComponentConfiguration = null;
        while (cycleIterator.hasNext()) {
            ReferenceComponentConfiguration cycleRefComponentConfiguration = (ReferenceComponentConfiguration)cycleIterator.next();
            if (cycleRefComponentConfiguration.ref.getReferenceDescription().isRequired()) continue;
            optionalRefComponentConfiguration = cycleRefComponentConfiguration;
            break;
        }
        if (optionalRefComponentConfiguration == null) {
            throw new CircularityException(refComponentConfiguration.ref.getComponentConfiguration());
        }
        optionalRefComponentConfiguration.ref.getComponentConfiguration().setDelayActivateComponentConfigurationName(optionalRefComponentConfiguration.producer.getComponentDescription().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextComponentId() {
        Resolver resolver = this;
        synchronized (resolver) {
            return componentid++;
        }
    }

    private static class ReferenceComponentConfiguration {
        public Reference ref;
        public ComponentConfiguration producer;

        protected ReferenceComponentConfiguration(Reference ref, ComponentConfiguration producer) {
            this.ref = ref;
            this.producer = producer;
        }
    }
}

