/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.resolver;

import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.ds.model.ComponentConfiguration;
import org.eclipse.equinox.ds.model.ReferenceDescription;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class Reference {
    private static final String TARGET = ".target";
    private ReferenceDescription referenceDescription;
    private ComponentConfiguration componentConfiguration;
    private String target;
    private Set serviceReferences = new HashSet();
    private Map serviceReferenceToServiceObject = new Hashtable();

    Reference(ReferenceDescription referenceDescription, Hashtable properties) {
        this.referenceDescription = referenceDescription;
        this.target = (String)properties.get(String.valueOf(referenceDescription.getName()) + TARGET);
        this.target = this.target != null ? this.target : referenceDescription.getTarget();
        this.target = this.target != null ? this.target : "(objectClass=" + referenceDescription.getInterfacename() + ")";
    }

    void setComponentConfiguration(ComponentConfiguration parent) {
        this.componentConfiguration = parent;
    }

    public ComponentConfiguration getComponentConfiguration() {
        return this.componentConfiguration;
    }

    boolean hasProvider(BundleContext context) {
        try {
            ServiceReference[] providers = null;
            providers = context.getServiceReferences(this.referenceDescription.getInterfacename(), this.target);
            return providers != null;
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    public ReferenceDescription getReferenceDescription() {
        return this.referenceDescription;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean dynamicBindReference(ServiceReference serviceReference) {
        Filter filter;
        if ("static".equals(this.referenceDescription.getPolicy())) {
            return false;
        }
        List<String> provideList = Arrays.asList((String[])serviceReference.getProperty("objectClass"));
        if (!provideList.contains(this.getReferenceDescription().getInterfacename())) {
            return false;
        }
        try {
            filter = FrameworkUtil.createFilter((String)this.target);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
        if (!filter.match(serviceReference)) {
            return false;
        }
        int currentRefCount = this.serviceReferences.size();
        return currentRefCount < this.referenceDescription.getCardinalityHigh();
    }

    boolean dynamicUnbindReference(ServiceReference serviceReference) {
        if ("static".equals(this.referenceDescription.getPolicy())) {
            return false;
        }
        return this.serviceReferences.contains(serviceReference);
    }

    public void addServiceReference(ServiceReference serviceReference) {
        this.serviceReferences.add(serviceReference);
    }

    public void removeServiceReference(ServiceReference serviceReference) {
        this.serviceReferences.remove(serviceReference);
        this.serviceReferenceToServiceObject.remove(serviceReference);
    }

    public void clearServiceReferences() {
        this.serviceReferences.clear();
        this.serviceReferenceToServiceObject.clear();
    }

    public Set getServiceReferences() {
        return this.serviceReferences;
    }

    public boolean bindedToServiceReference(ServiceReference serviceReference) {
        return this.serviceReferences.contains(serviceReference);
    }

    public void addServiceReference(ServiceReference serviceReference, Object serviceObject) {
        this.addServiceReference(serviceReference);
        this.serviceReferenceToServiceObject.put(serviceReference, serviceObject);
    }

    public Object getServiceObject(ServiceReference serviceReference) {
        return this.serviceReferenceToServiceObject.get(serviceReference);
    }

    ComponentConfiguration findProviderComponentConfiguration(List componentConfigurations) {
        Filter filter;
        try {
            filter = FrameworkUtil.createFilter((String)this.target);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return null;
        }
        Iterator it = componentConfigurations.iterator();
        while (it.hasNext()) {
            ComponentConfiguration providerComponentConfiguration = (ComponentConfiguration)it.next();
            List provideList = providerComponentConfiguration.getComponentDescription().getServicesProvided();
            if (!provideList.contains(this.getReferenceDescription().getInterfacename()) || !filter.match((Dictionary)providerComponentConfiguration.getProperties())) continue;
            return providerComponentConfiguration;
        }
        return null;
    }
}

