/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.equinox.ds.Activator;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.parser.ParserHandler;
import org.eclipse.equinox.ds.parser.XMLParserNotAvailableException;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Parser
implements ServiceTrackerCustomizer {
    private Activator main;
    private ServiceTracker parserTracker;
    private List delayedParseBundles = new ArrayList();

    public Parser(Activator main) {
        this.main = main;
        this.parserTracker = new ServiceTracker(main.context, "javax.xml.parsers.SAXParserFactory", (ServiceTrackerCustomizer)this);
        this.parserTracker.open();
    }

    public void dispose() {
        this.parserTracker.close();
    }

    public List getComponentDescriptions(BundleContext bundleContext) throws XMLParserNotAvailableException {
        ArrayList result;
        ManifestElement[] xml = this.parseManifestHeader(bundleContext.getBundle());
        if (xml != null) {
            result = new ArrayList(xml.length);
            int i = 0;
            while (i < xml.length) {
                List components = this.parseComponentDescription(bundleContext, xml[i].getValue());
                result.addAll(components);
                ++i;
            }
        } else {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    private ManifestElement[] parseManifestHeader(Bundle bundle) {
        Dictionary headers = bundle.getHeaders();
        String files = (String)headers.get("Service-Component");
        try {
            return ManifestElement.parseHeader((String)"Service-Component", (String)files);
        }
        catch (BundleException e) {
            Log.log(1, "[SCR] Error attempting parse Manifest Element Header. ", e);
            return new ManifestElement[0];
        }
    }

    private List parseComponentDescription(BundleContext bundleContext, String xml) throws XMLParserNotAvailableException {
        SAXParserFactory parserFactory = (SAXParserFactory)this.parserTracker.getService();
        if (parserFactory == null) {
            try {
                parserFactory = SAXParserFactory.newInstance();
            }
            catch (FactoryConfigurationError factoryConfigurationError) {
                this.delayedParseBundles.add(bundleContext.getBundle());
                throw new XMLParserNotAvailableException();
            }
        }
        ArrayList result = new ArrayList();
        int fileIndex = xml.lastIndexOf(47);
        String path = fileIndex != -1 ? xml.substring(0, fileIndex) : "/";
        try {
            Enumeration urls = bundleContext.getBundle().findEntries(path, xml.substring(fileIndex + 1), false);
            if (urls == null || !urls.hasMoreElements()) {
                throw new BundleException("resource not found: " + xml);
            }
            URL url = (URL)urls.nextElement();
            InputStream is = url.openStream();
            parserFactory.setNamespaceAware(true);
            parserFactory.setValidating(false);
            SAXParser saxParser = parserFactory.newSAXParser();
            saxParser.parse(is, (DefaultHandler)new ParserHandler(bundleContext, result));
        }
        catch (IOException e) {
            Log.log(1, "[SCR] IOException attempting to parse ComponentDescription XML. ", e);
        }
        catch (BundleException e) {
            Log.log(1, "[SCR] BundleException attempting to parse ComponentDescription XML. ", e);
        }
        catch (SAXException e) {
            Log.log(1, "[SCR] SAXException attempting to parse ComponentDescription XML. ", e);
        }
        catch (ParserConfigurationException e) {
            Log.log(1, "[SCR] ParserConfigurationException attempting to parse ComponentDescription XML. ", e);
        }
        return result;
    }

    public Object addingService(ServiceReference reference) {
        Object xmlParser = this.main.context.getService(reference);
        Iterator delayedParseBundlesItr = this.delayedParseBundles.iterator();
        while (delayedParseBundlesItr.hasNext()) {
            Bundle bundle = (Bundle)delayedParseBundlesItr.next();
            delayedParseBundlesItr.remove();
            if (bundle.getState() != 32) continue;
            this.main.addingBundle(bundle);
        }
        return xmlParser;
    }

    public void modifiedService(ServiceReference reference, Object object) {
    }

    public void removedService(ServiceReference reference, Object object) {
        this.main.context.ungetService(reference);
    }
}

