/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.model;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.model.ComponentConfiguration;
import org.eclipse.equinox.ds.model.ImplementationDescription;
import org.eclipse.equinox.ds.model.PropertyDescription;
import org.eclipse.equinox.ds.model.PropertyResourceDescription;
import org.eclipse.equinox.ds.model.PropertyValueDescription;
import org.eclipse.equinox.ds.model.ProvideDescription;
import org.eclipse.equinox.ds.model.ReferenceDescription;
import org.eclipse.equinox.ds.model.ServiceDescription;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentException;

public class ComponentDescription
implements Serializable {
    private static final long serialVersionUID = -6131574862715499271L;
    private transient BundleContext bundleContext;
    private String name;
    private boolean autoenable;
    private boolean immediate;
    private boolean enabled;
    private boolean valid;
    private String factory;
    private ImplementationDescription implementation;
    private List propertyDescriptions;
    private ServiceDescription service;
    private List servicesProvided;
    private List referenceDescriptions;
    private transient List componentConfigurations;
    private transient boolean activateMethodInitialized;
    private transient Method activateMethod;
    private transient boolean deactivateMethodInitialized;
    private transient Method deactivateMethod;
    private transient Map properties;
    private transient Map componentConfigurationsByPID;

    public ComponentDescription(BundleContext bundleContext) {
        this.bundleContext = bundleContext;
        this.autoenable = true;
        this.immediate = false;
        this.propertyDescriptions = new ArrayList();
        this.referenceDescriptions = new ArrayList();
        this.componentConfigurations = new ArrayList();
        this.componentConfigurationsByPID = new Hashtable();
        this.servicesProvided = Collections.EMPTY_LIST;
    }

    public boolean isAutoenable() {
        return this.autoenable;
    }

    public void setAutoenable(boolean autoenable) {
        this.autoenable = autoenable;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public void setImmediate(boolean immediate) {
        this.immediate = immediate;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    void setBundleContext(BundleContext context) {
        this.bundleContext = context;
    }

    public String getFactory() {
        return this.factory;
    }

    public void setFactory(String factory) {
        this.factory = factory;
    }

    public ImplementationDescription getImplementation() {
        return this.implementation;
    }

    public void setImplementation(ImplementationDescription implementation) {
        this.implementation = implementation;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Map getProperties() {
        if (this.properties == null) {
            this.properties = this.propertyDescriptions.isEmpty() ? Collections.EMPTY_MAP : new Hashtable(this.propertyDescriptions.size());
            Iterator it = this.propertyDescriptions.iterator();
            while (it.hasNext()) {
                PropertyDescription propertyDescription = (PropertyDescription)it.next();
                if (propertyDescription instanceof PropertyValueDescription) {
                    PropertyValueDescription propvalue = (PropertyValueDescription)propertyDescription;
                    this.properties.put(propvalue.getName(), propvalue.getValue());
                    continue;
                }
                this.properties.putAll(this.loadPropertyFile(((PropertyResourceDescription)propertyDescription).getEntry()));
            }
        }
        return this.properties;
    }

    public void addPropertyDescription(PropertyDescription propertyDescription) {
        this.propertyDescriptions.add(propertyDescription);
    }

    private Hashtable loadPropertyFile(String propertyEntryName) {
        URL url = null;
        Properties props = new Properties();
        url = this.getBundleContext().getBundle().getEntry(propertyEntryName);
        if (url == null) {
            throw new ComponentException("Properties entry file " + propertyEntryName + " cannot be found");
        }
        try {
            InputStream in = null;
            File file = new File(propertyEntryName);
            in = file.exists() ? new FileInputStream(file) : url.openStream();
            if (in != null) {
                props.load(new BufferedInputStream(in));
                in.close();
            } else {
                Log.log(2, "Unable to find properties file " + propertyEntryName);
            }
        }
        catch (IOException iOException) {
            throw new ComponentException("Properties entry file " + propertyEntryName + " cannot be read");
        }
        return props;
    }

    public ServiceDescription getService() {
        return this.service;
    }

    public List getServicesProvided() {
        return this.servicesProvided;
    }

    public void setService(ServiceDescription service) {
        this.service = service;
        if (service != null) {
            this.servicesProvided = new ArrayList();
            ProvideDescription[] provideDescription = service.getProvides();
            int i = 0;
            while (i < provideDescription.length) {
                this.servicesProvided.add(provideDescription[i].getInterfacename());
                ++i;
            }
        } else {
            this.servicesProvided = Collections.EMPTY_LIST;
        }
    }

    public List getReferenceDescriptions() {
        return this.referenceDescriptions;
    }

    public void addReferenceDescription(ReferenceDescription reference) {
        this.referenceDescriptions.add(reference);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public void addComponentConfiguration(ComponentConfiguration componentConfiguration) {
        this.componentConfigurations.add(componentConfiguration);
        String pid = (String)componentConfiguration.getProperties().get("service.pid");
        if (pid != null) {
            this.componentConfigurationsByPID.put(pid, componentConfiguration);
        }
    }

    public List getComponentConfigurations() {
        return this.componentConfigurations;
    }

    public ComponentConfiguration getComponentConfigurationByPID(String pid) {
        return (ComponentConfiguration)this.componentConfigurationsByPID.get(pid);
    }

    public void clearComponentConfigurations() {
        this.componentConfigurations.clear();
        this.componentConfigurationsByPID.clear();
    }

    public void clearReflectionMethods() {
        this.activateMethodInitialized = false;
        this.activateMethod = null;
        this.deactivateMethodInitialized = false;
        this.deactivateMethod = null;
        Iterator iter = this.referenceDescriptions.iterator();
        while (iter.hasNext()) {
            ReferenceDescription rd = (ReferenceDescription)iter.next();
            rd.setBindMethod(null);
            rd.setUnbindMethod(null);
        }
    }

    public void removeComponentConfiguration(ComponentConfiguration componentConfiguration) {
        this.componentConfigurations.remove(componentConfiguration);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.componentConfigurations = new ArrayList();
        this.componentConfigurationsByPID = new Hashtable();
    }

    public Method getActivateMethod() {
        return this.activateMethod;
    }

    public void setActivateMethod(Method activateMethod) {
        this.activateMethodInitialized = true;
        this.activateMethod = activateMethod;
    }

    public boolean isActivateMethodInitialized() {
        return this.activateMethodInitialized;
    }

    public Method getDeactivateMethod() {
        return this.deactivateMethod;
    }

    public void setDeactivateMethod(Method deactivateMethod) {
        this.deactivateMethodInitialized = true;
        this.deactivateMethod = deactivateMethod;
    }

    public boolean isDeactivateMethodInitialized() {
        return this.deactivateMethodInitialized;
    }
}

