/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.ds.instance;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.eclipse.equinox.ds.Log;
import org.eclipse.equinox.ds.instance.BuildDispose;
import org.eclipse.equinox.ds.model.ComponentDescription;
import org.eclipse.equinox.ds.resolver.Reference;
import org.eclipse.equinox.ds.service.ComponentInstanceImpl;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

class InvokeMethod {
    private BuildDispose buildDispose;
    private static final Class[] PARAM_COMPONENTCONTEXT;
    private static final Class[] PARAM_SERVICEREFERENCE;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.component.ComponentContext");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        PARAM_COMPONENTCONTEXT = classArray;
        Class[] classArray2 = new Class[1];
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.osgi.framework.ServiceReference");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray2[0] = clazz2;
        PARAM_SERVICEREFERENCE = classArray2;
    }

    InvokeMethod(BuildDispose buildDispose) {
        this.buildDispose = buildDispose;
    }

    void activateComponent(Object instance, ComponentContext context) throws IllegalAccessException, InvocationTargetException {
        ComponentDescription cd = ((ComponentInstanceImpl)context.getComponentInstance()).getComponentConfiguration().getComponentDescription();
        Method method = cd.getActivateMethod();
        if (method == null && !cd.isActivateMethodInitialized()) {
            method = this.findActivateOrDeactivateMethod("activate", instance.getClass());
            cd.setActivateMethod(method);
        }
        Object[] parameterTypes = new Object[]{context};
        if (method != null) {
            this.invokeMethod(method, instance, parameterTypes);
        }
    }

    void deactivateComponent(Object instance, ComponentContext context) throws IllegalAccessException, InvocationTargetException {
        ComponentDescription cd = ((ComponentInstanceImpl)context.getComponentInstance()).getComponentConfiguration().getComponentDescription();
        Method method = cd.getDeactivateMethod();
        if (method == null && !cd.isDeactivateMethodInitialized()) {
            method = this.findActivateOrDeactivateMethod("deactivate", instance.getClass());
            cd.setDeactivateMethod(method);
        }
        Object[] parameterTypes = new Object[]{context};
        if (method != null) {
            this.invokeMethod(method, instance, parameterTypes);
        }
    }

    void bindComponent(Method bindMethod, Object instance, Object param) throws IllegalAccessException, InvocationTargetException {
        Object[] parameterTypes = new Object[]{param};
        this.invokeMethod(bindMethod, instance, parameterTypes);
    }

    void unbindComponent(Method unbindMethod, Object instance, Object param) throws IllegalAccessException, InvocationTargetException {
        Object[] parameterTypes = new Object[]{param};
        this.invokeMethod(unbindMethod, instance, parameterTypes);
    }

    private void invokeMethod(Method method, Object instance, Object[] parameterTypes) throws IllegalAccessException, InvocationTargetException {
        int mod = method.getModifiers();
        if (Modifier.isProtected(mod) || Modifier.isPublic(mod)) {
            if (Modifier.isProtected(mod)) {
                method.setAccessible(true);
            }
            method.invoke(instance, parameterTypes);
        }
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Method findActivateOrDeactivateMethod(String methodName, Class consumerClass) {
        Class<?> clazz;
        Method method = null;
        boolean bl = true;
        do {
            if (!bl || (bl = false) || !true) {
                try {
                    method = consumerClass.getDeclaredMethod(methodName, PARAM_COMPONENTCONTEXT);
                }
                catch (NoSuchMethodException noSuchMethodException) {}
                if (method != null) break;
                consumerClass = consumerClass.getSuperclass();
            }
            if ((clazz = class$2) != null) continue;
            try {
                clazz = Class.forName("java.lang.Object");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        } while (!consumerClass.equals(clazz) && method == null);
        if (method == null) return method;
        int modifier = method.getModifiers();
        if (Modifier.isProtected(modifier)) return method;
        if (Modifier.isPublic(modifier)) return method;
        Log.log(1, "[SCR] Method " + methodName + " is not protected or public.");
        return null;
    }

    Method findBindOrUnbindMethod(ComponentInstanceImpl componentInstance, Reference reference, ServiceReference serviceReference, String methodName) {
        Class<?> consumerClass = componentInstance.getInstance().getClass();
        Object serviceObject = null;
        Class<?> serviceObjectClass = null;
        Class<?> interfaceClass = null;
        Class[] param_interfaceClass = null;
        Method method = null;
        while (consumerClass != null) {
            try {
                method = consumerClass.getDeclaredMethod(methodName, PARAM_SERVICEREFERENCE);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (method != null) break;
            if (serviceObject == null) {
                serviceObject = reference.getServiceObject(serviceReference);
                if (serviceObject == null) {
                    serviceObject = this.buildDispose.getService(reference, serviceReference);
                }
                if (serviceObject == null) {
                    return null;
                }
                reference.addServiceReference(serviceReference, serviceObject);
                Class<?> searchForInterfaceClass = serviceObjectClass = serviceObject.getClass();
                String interfaceName = reference.getReferenceDescription().getInterfacename();
                while (searchForInterfaceClass != null) {
                    Class<?>[] interfaceClasses = searchForInterfaceClass.getInterfaces();
                    int i = 0;
                    while (i < interfaceClasses.length) {
                        if (interfaceClasses[i].getName().equals(interfaceName)) {
                            interfaceClass = interfaceClasses[i];
                            break;
                        }
                        ++i;
                    }
                    if (interfaceClass != null) break;
                    if (searchForInterfaceClass.getName().equals(interfaceName)) {
                        interfaceClass = searchForInterfaceClass;
                        break;
                    }
                    searchForInterfaceClass = searchForInterfaceClass.getSuperclass();
                }
                param_interfaceClass = new Class[]{interfaceClass};
            }
            try {
                method = consumerClass.getDeclaredMethod(methodName, param_interfaceClass);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
            if (method != null) break;
            Method[] methods = consumerClass.getDeclaredMethods();
            int i = 0;
            while (i < methods.length) {
                Class<?>[] params = methods[i].getParameterTypes();
                if (params.length == 1 && methods[i].getName().equals(methodName) && params[0].isAssignableFrom(serviceObjectClass)) {
                    method = methods[i];
                    break;
                }
                ++i;
            }
            if (method != null) break;
            consumerClass = consumerClass.getSuperclass();
        }
        if (method == null) {
            Log.log(1, "[SCR] Could not find method " + methodName + ".");
            return null;
        }
        int modifier = method.getModifiers();
        if (!Modifier.isProtected(modifier) && !Modifier.isPublic(modifier)) {
            Log.log(1, "[SCR] Method " + methodName + " is not protected or public.");
            return null;
        }
        return method;
    }
}

