/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin;

import java.io.PrintStream;
import java.net.URL;
import java.security.AccessController;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import sun.applet.AppletPanel;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;

class ClassLoaderInfo {
    private URL codebase;
    private String key;
    private int references = 0;
    private HashMap jars;
    private boolean locked;
    private boolean notcache = false;
    private static boolean initialized;
    private static HashMap infos;
    private static int zombieLimit;
    private static ArrayList zombies;
    private boolean localJarsLoaded = false;

    private static synchronized void initialize() {
        if (initialized) {
            return;
        }
        initialized = true;
        ClassLoaderInfo.reset();
    }

    public static synchronized void reset() {
        initialized = true;
        zombieLimit = 0;
        String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.classloader.cache.enabled"));
        if (string == null || string.equals("true")) {
            zombieLimit = Integer.getInteger("javaplugin.classloader.cache.sizes", 4);
        }
        if (zombieLimit > 4) {
            zombieLimit = 4;
        }
    }

    public static synchronized void clearClassLoaderCache() {
        Object object;
        Iterator iterator = ((AbstractList)zombies).iterator();
        while (iterator.hasNext()) {
            object = (ClassLoaderInfo)iterator.next();
            if (object == null) continue;
            infos.remove(((ClassLoaderInfo)object).key);
            AppletPanel.flushClassLoader((String)((ClassLoaderInfo)object).key);
        }
        zombies.clear();
        object = infos.values();
        if (object != null) {
            iterator = object.iterator();
            while (iterator.hasNext()) {
                ClassLoaderInfo classLoaderInfo = (ClassLoaderInfo)iterator.next();
                if (classLoaderInfo == null) continue;
                classLoaderInfo.notcache = true;
            }
        }
        AppletPanel.flushClassLoaders();
    }

    public static synchronized void dumpClassLoaderCache(PrintStream printStream) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Dump classloader list ...\n");
        Collection collection = infos.values();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ClassLoaderInfo classLoaderInfo = (ClassLoaderInfo)iterator.next();
                if (classLoaderInfo == null) continue;
                boolean bl = zombies.contains(classLoaderInfo);
                stringBuffer.append("    codebase=" + classLoaderInfo.codebase);
                stringBuffer.append(", key=" + classLoaderInfo.key);
                stringBuffer.append(", zombie=" + bl);
                stringBuffer.append(", cache=" + !classLoaderInfo.notcache);
                stringBuffer.append(", info=" + classLoaderInfo);
                stringBuffer.append("\n");
            }
        }
        stringBuffer.append("Done.");
        printStream.println(stringBuffer.toString());
    }

    static synchronized ClassLoaderInfo find(AppletPanel appletPanel) {
        ClassLoaderInfo.initialize();
        URL uRL = appletPanel.getCodeBase();
        if (uRL == null) {
            return null;
        }
        String string = appletPanel.getClassLoaderCacheKey();
        ClassLoaderInfo classLoaderInfo = (ClassLoaderInfo)infos.get(string);
        if (classLoaderInfo == null) {
            classLoaderInfo = new ClassLoaderInfo(uRL, string);
            infos.put(string, classLoaderInfo);
        } else {
            ((AbstractCollection)zombies).remove(classLoaderInfo);
        }
        return classLoaderInfo;
    }

    synchronized void addReference() {
        ++this.references;
        Trace.println("Referencing classloader: " + this + ", refcount=" + this.references, 2);
    }

    synchronized void removeReference() {
        --this.references;
        Trace.println("Releasing classloader: " + this + ", refcount=" + this.references, 2);
        if (this.references < 0) {
            throw new Error("negative ref count???");
        }
        if (this.references == 0) {
            ClassLoaderInfo.addZombie(this);
        }
    }

    private static synchronized void addZombie(ClassLoaderInfo classLoaderInfo) {
        if (classLoaderInfo.notcache) {
            ((AbstractCollection)zombies).remove(classLoaderInfo);
            infos.remove(classLoaderInfo.key);
            AppletPanel.flushClassLoader((String)classLoaderInfo.key);
        } else {
            Trace.println("Caching classloader: " + classLoaderInfo, 2);
            zombies.add(classLoaderInfo);
            Trace.println("Current classloader cache size: " + zombies.size(), 2);
            if (zombies.size() > zombieLimit) {
                ClassLoaderInfo classLoaderInfo2 = (ClassLoaderInfo)zombies.get(0);
                Trace.println("Number of cached classloaders over " + zombieLimit + ", unreference " + classLoaderInfo2, 2);
                zombies.remove(0);
                infos.remove(classLoaderInfo2.key);
                AppletPanel.flushClassLoader((String)classLoaderInfo2.key);
            }
        }
    }

    private ClassLoaderInfo(URL uRL, String string) {
        this.codebase = uRL;
        this.key = string;
        this.jars = new HashMap();
    }

    synchronized void addJar(String string) {
        this.jars.put(string, string);
    }

    synchronized boolean hasJar(String string) {
        return this.jars.get(string) != null;
    }

    public boolean getLocalJarsLoaded() {
        return this.localJarsLoaded;
    }

    public void setLocalJarsLoaded(boolean bl) {
        this.localJarsLoaded = bl;
    }

    public final synchronized void lock() throws InterruptedException {
        while (this.locked) {
            this.wait();
        }
        this.locked = true;
    }

    public final synchronized void unlock() {
        this.locked = false;
        this.notifyAll();
    }

    static {
        infos = new HashMap();
        zombieLimit = 0;
        zombies = new ArrayList();
    }
}

