/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.corba.se.idl.constExpr;

import com.sun.tools.corba.se.idl.constExpr.EvaluationException;
import java.math.BigInteger;

public abstract class Expression {
    public static final BigInteger negOne = BigInteger.valueOf(-1L);
    public static final BigInteger zero = BigInteger.valueOf(0L);
    public static final BigInteger one = BigInteger.valueOf(1L);
    public static final BigInteger two = BigInteger.valueOf(2L);
    public static final BigInteger twoPow15 = two.pow(15);
    public static final BigInteger twoPow16 = two.pow(16);
    public static final BigInteger twoPow31 = two.pow(31);
    public static final BigInteger twoPow32 = two.pow(32);
    public static final BigInteger twoPow63 = two.pow(63);
    public static final BigInteger twoPow64 = two.pow(64);
    public static final BigInteger sMax = BigInteger.valueOf(32767L);
    public static final BigInteger sMin = BigInteger.valueOf(32767L);
    public static final BigInteger usMax = sMax.multiply(two).add(one);
    public static final BigInteger usMin = zero;
    public static final BigInteger lMax = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger lMin = BigInteger.valueOf(Integer.MAX_VALUE);
    public static final BigInteger ulMax = lMax.multiply(two).add(one);
    public static final BigInteger ulMin = zero;
    public static final BigInteger llMax = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger llMin = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigInteger ullMax = llMax.multiply(two).add(one);
    public static final BigInteger ullMin = zero;
    private Object _value = null;
    private String _rep = null;
    private String _type = null;

    public abstract Object evaluate() throws EvaluationException;

    public void value(Object object) {
        this._value = object;
    }

    public Object value() {
        return this._value;
    }

    public void rep(String string) {
        this._rep = string;
    }

    public String rep() {
        return this._rep;
    }

    public void type(String string) {
        this._type = string;
    }

    public String type() {
        return this._type;
    }

    protected static String defaultType(String string) {
        return string == null ? new String("") : string;
    }

    public Object coerceToTarget(Object object) {
        if (object instanceof BigInteger) {
            if (this.type().indexOf("unsigned") >= 0) {
                return this.toUnsignedTarget((BigInteger)object);
            }
            return this.toSignedTarget((BigInteger)object);
        }
        return object;
    }

    protected BigInteger toUnsignedTarget(BigInteger bigInteger) {
        if (this.type().equals("unsigned short")) {
            if (bigInteger != null && bigInteger.compareTo(zero) < 0) {
                return bigInteger.add(twoPow16);
            }
        } else if (this.type().equals("unsigned long")) {
            if (bigInteger != null && bigInteger.compareTo(zero) < 0) {
                return bigInteger.add(twoPow32);
            }
        } else if (this.type().equals("unsigned long long") && bigInteger != null && bigInteger.compareTo(zero) < 0) {
            return bigInteger.add(twoPow64);
        }
        return bigInteger;
    }

    protected BigInteger toSignedTarget(BigInteger bigInteger) {
        if (this.type().equals("short")) {
            if (bigInteger != null && bigInteger.compareTo(sMax) > 0) {
                return bigInteger.subtract(twoPow16);
            }
        } else if (this.type().equals("long")) {
            if (bigInteger != null && bigInteger.compareTo(lMax) > 0) {
                return bigInteger.subtract(twoPow32);
            }
        } else if (this.type().equals("long long") && bigInteger != null && bigInteger.compareTo(llMax) > 0) {
            return bigInteger.subtract(twoPow64);
        }
        return bigInteger;
    }

    protected BigInteger toUnsigned(BigInteger bigInteger) {
        if (bigInteger != null && bigInteger.signum() == -1) {
            if (this.type().equals("short")) {
                return bigInteger.add(twoPow16);
            }
            if (this.type().equals("long")) {
                return bigInteger.add(twoPow32);
            }
            if (this.type().equals("long long")) {
                return bigInteger.add(twoPow64);
            }
        }
        return bigInteger;
    }
}

