/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.nativecomm.host;

import com.adobe.csi.core.logging.Logger;
import com.adobe.versioncue.internal.nativecomm.host.ConnectionHandler;
import com.adobe.versioncue.internal.nativecomm.host.SocketListener;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.SerializerFactory;
import com.adobe.versioncue.nativecomm.host.IHandlerRegistry;
import com.adobe.versioncue.nativecomm.host.IRequestHandler;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;

public final class HostController {
    private static final Logger LOG = Logger.getLogger(HostController.class);
    private static final Map<String, SocketListener> socketListeners = new ConcurrentHashMap<String, SocketListener>();
    private static final AtomicReference<IHandlerRegistry> handlerRegistry = new AtomicReference();

    private HostController() {
    }

    public static void addConnection(InputStream in, OutputStream out, Runnable finalizer) throws NativeCommException {
        ConnectionHandler handler = new ConnectionHandler(SerializerFactory.getInstance().serializer(in, out, false), finalizer);
        handler.start();
    }

    public static int startSocketListener(String hostname, int port) throws IOException {
        assert (port >= 0 && port < 65536) : "port >= 0 && port < 65536";
        if (port != 0 && socketListeners.containsKey(port)) {
            return port;
        }
        InetAddress addr = hostname != null ? InetAddress.getByName(hostname) : null;
        ServerSocket socket = new ServerSocket();
        socket.setReuseAddress(true);
        socket.bind(new InetSocketAddress(addr, port));
        int localPort = socket.getLocalPort();
        SocketListener listener = new SocketListener(socket);
        Thread thread = new Thread((Runnable)listener, "SocketListener-" + localPort);
        thread.setDaemon(false);
        thread.start();
        String key = String.valueOf(hostname != null ? hostname : "*") + ':' + localPort;
        socketListeners.put(key, listener);
        return localPort;
    }

    public static void stopSocketListener(String hostname, int port) {
        String key = String.valueOf(hostname != null ? hostname : "*") + ':' + port;
        SocketListener listener = socketListeners.remove(key);
        if (listener == null) {
            return;
        }
        listener.shutdown();
    }

    public static IRequestHandler getHandler(String method) {
        try {
            int i = 0;
            while (i < 40) {
                IHandlerRegistry registry = handlerRegistry.get();
                if (registry != null) {
                    return registry.getHandler(method);
                }
                Thread.sleep(500L);
                ++i;
            }
            LOG.error((Object)("getHandler() has timed out for: " + method));
        }
        catch (InterruptedException interruptedException) {
            LOG.error((Object)("getHandler() was interrupted waiting for: " + method));
        }
        return null;
    }

    public static void setHandlerRegistry(IHandlerRegistry registry) {
        handlerRegistry.compareAndSet(null, registry);
    }

    public static void unsetHandlerRegistry(IHandlerRegistry registry) {
        handlerRegistry.compareAndSet(registry, null);
    }
}

