/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm.host;

import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.host.IRequest;
import com.adobe.versioncue.nativecomm.msg.BadMessageException;
import com.adobe.versioncue.nativecomm.msg.NCList;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCType;

public class RequestImpl
implements IRequest {
    private static final String ERR_CODE = "errReason";
    private static final String ERR_MSG = "errWhy";
    private final String method;
    private final NCMap params;
    private final NCMap results = new NCMap();
    private boolean succeeded = true;

    public RequestImpl(String method, NCMap params) {
        assert (method != null) : "method != null";
        assert (params != null) : "params != null";
        this.method = method;
        this.params = params;
    }

    public NCMap getParams() {
        return this.params;
    }

    public String getMethod() {
        return this.method;
    }

    public NCMap getResults() {
        return this.results;
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    public void fail(String reasonCode) {
        this.fail(reasonCode, null);
    }

    public void fail(String reasonCode, String errMessage) {
        this.succeeded = false;
        this.results.clear();
        this.results.put(ERR_CODE, reasonCode);
        if (errMessage != null) {
            this.results.put(ERR_MSG, errMessage);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("NComm.Request: ").append(this.method).append(' ');
        if (this.succeeded) {
            result.append("Succeded");
        } else {
            result.append("Failed (err='").append(this.results.get(ERR_CODE));
            result.append("' msg='").append(this.results.get(ERR_MSG)).append('\'');
        }
        return result.toString();
    }

    public static RequestImpl createRequest(NCType object) throws NativeCommException {
        assert (object != null) : "object != null";
        if (object.getType() != 6) {
            throw new BadMessageException("Invalid request: " + object);
        }
        NCList list = (NCList)object;
        if (list.size() < 2) {
            throw new BadMessageException("Invalid request: " + object);
        }
        String method = list.getString(0);
        NCMap params = list.getMap(1);
        return new RequestImpl(method, params);
    }
}

