/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm.host;

import com.adobe.csi.core.logging.Logger;
import com.adobe.versioncue.nativecomm.host.HostController;
import com.adobe.versioncue.nativecomm.host.IHandlerRegistry;
import com.adobe.versioncue.nativecomm.host.IRequestHandler;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class HandlerRegistry
implements IHandlerRegistry {
    private final Logger LOG = Logger.getLogger(HandlerRegistry.class);
    private final Map<String, IRequestHandler> handlers = new ConcurrentHashMap<String, IRequestHandler>();
    private final Map<String, ServiceReference> references = new ConcurrentHashMap<String, ServiceReference>();
    private ComponentContext context;

    public IRequestHandler getHandler(String method) {
        try {
            int i = 0;
            while (i < 40) {
                IRequestHandler handler = this.internalGet(method);
                if (handler != null) {
                    return handler;
                }
                Thread.sleep(500L);
                ++i;
            }
            this.LOG.error((Object)("getHandler() has timed out for: " + method));
        }
        catch (InterruptedException interruptedException) {
            this.LOG.error((Object)("getHandler() was interrupted waiting for: " + method));
        }
        return null;
    }

    protected void activate(ComponentContext context) {
        this.context = context;
        HostController.setHandlerRegistry(this);
    }

    protected void deactivate(ComponentContext context) {
        HostController.unsetHandlerRegistry(this);
        this.context = null;
    }

    protected void addRequestHandler(ServiceReference reference) {
        this.references.put(reference.getProperty("nativecomm.method").toString(), reference);
    }

    protected void removeRequestHandler(ServiceReference reference) {
        String method = reference.getProperty("nativecomm.method").toString();
        this.references.remove(method);
        this.handlers.remove(method);
    }

    private IRequestHandler internalGet(String method) {
        IRequestHandler handler = this.handlers.get(method);
        if (handler != null) {
            return handler;
        }
        ServiceReference reference = this.references.get(method);
        if (reference == null) {
            return null;
        }
        handler = (IRequestHandler)this.context.locateService("IRequestHandler", reference);
        this.handlers.put(method, handler);
        return handler;
    }
}

