/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.versioncue.internal.nativecomm.host;

import com.adobe.csi.core.logging.Logger;
import com.adobe.versioncue.internal.nativecomm.host.RequestImpl;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.ServiceCallException;
import com.adobe.versioncue.nativecomm.host.HostController;
import com.adobe.versioncue.nativecomm.host.IRequestHandler;
import com.adobe.versioncue.nativecomm.io.ISerializer;
import com.adobe.versioncue.nativecomm.msg.BadMessageException;
import com.adobe.versioncue.nativecomm.msg.NCList;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import com.adobe.versioncue.nativecomm.msg.NCNull;
import com.adobe.versioncue.nativecomm.msg.NCType;
import java.io.EOFException;
import java.io.IOException;

public class ConnectionHandler
implements Runnable {
    private static final boolean DO_TRACE = Boolean.getBoolean("adfs.traceNComm");
    static final String BUNDLE_ID = "com.adobe.versioncue.nativecomm.host";
    static final String TRACING_OPTION_REQ_METHOD = "com.adobe.versioncue.nativecomm.host/request/name";
    static final String TRACING_OPTION_REQ_PARAM = "com.adobe.versioncue.nativecomm.host/request/parameter";
    private static int nextHandlerId = 0;
    private static final Logger LOGGER = Logger.getLogger(ConnectionHandler.class);
    private static final int RESULT_SUCCESS = 0;
    private static final int RESULT_ERROR = 1;
    private final Thread thread = new Thread((Runnable)this, ConnectionHandler.createHandlerName());
    private final ISerializer serializer;
    private final Runnable finalizer;

    public ConnectionHandler(ISerializer serializer) {
        this(serializer, new Runnable(){

            public void run() {
            }
        });
    }

    public ConnectionHandler(ISerializer serializer, Runnable finalizer) {
        this.thread.setDaemon(true);
        this.serializer = serializer;
        this.finalizer = finalizer;
    }

    public void start() {
        this.thread.start();
    }

    public void run() {
        try {
            try {
                NCType ncObject;
                while (!((ncObject = this.serializer.read()) instanceof NCNull)) {
                    long traceStart = 0L;
                    RequestImpl request = RequestImpl.createRequest(ncObject);
                    try {
                        IRequestHandler handler = HostController.getHandler(request.getMethod());
                        this.handleTracingStart(request, handler);
                        traceStart = System.currentTimeMillis();
                        if (handler != null) {
                            handler.handle(request);
                        } else {
                            request.fail("ncomm.noHandler", "Unsupported request: " + request.getMethod());
                            LOGGER.warn((Object)("Received unsupported request: " + request.getMethod()));
                        }
                    }
                    catch (ServiceCallException e) {
                        request.fail(e.reasonCode(), e.getMessage());
                    }
                    catch (BadMessageException e) {
                        request.fail("ncomm.badMessage", e.getMessage());
                        LOGGER.error((Object)("Received invalid request: " + request.getMethod() + " / " + request.getParams() + " - " + e.getMessage()));
                    }
                    catch (NativeCommException e) {
                        request.fail(((Object)((Object)e)).getClass().getName(), e.getMessage());
                    }
                    this.handleTracingEnd(request, traceStart);
                    this.write(request);
                }
            }
            catch (EOFException eOFException) {
                LOGGER.trace((Object)("Client connection '" + this.thread.getName() + "' closed!!"));
                this.serializer.dispose();
                this.finalizer.run();
            }
            catch (Exception e) {
                LOGGER.error((Object)"Caught exception", (Throwable)e);
                this.serializer.dispose();
                this.finalizer.run();
            }
        }
        finally {
            this.serializer.dispose();
            this.finalizer.run();
        }
    }

    private void write(RequestImpl result) throws IOException {
        assert (result != null) : "result != null";
        NCList list = new NCList(2);
        list.add(result.succeeded() ? 0 : 1);
        list.add((NCType)result.getResults());
        this.serializer.write((NCType)list);
        this.serializer.flush();
    }

    private static synchronized String createHandlerName() {
        return "ConnectionHandler-" + nextHandlerId++;
    }

    private void handleTracingStart(RequestImpl request, IRequestHandler handler) {
        String methodName = request.getMethod();
        if (this.isTraceOptionSet(TRACING_OPTION_REQ_METHOD)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Ncomm: ");
            buffer.append(methodName);
            buffer.append(", Handler: ");
            if (handler == null) {
                buffer.append("<null>");
            } else {
                buffer.append(handler.getClass().getName());
            }
            Logger.getLogger(ConnectionHandler.class).debug((Object)buffer);
        }
        if (this.isTraceOptionSet(TRACING_OPTION_REQ_PARAM)) {
            this.printNCMap(Logger.getLogger(ConnectionHandler.class), request.getParams(), request.getMethod(), "Parameters");
        }
    }

    private void handleTracingEnd(RequestImpl request, long startTime) {
        if (this.isTraceOptionSet(TRACING_OPTION_REQ_PARAM)) {
            this.printNCMap(Logger.getLogger(ConnectionHandler.class), request.getResults(), request.getMethod(), "Results");
            long duration = System.currentTimeMillis() - startTime;
            Logger.getLogger(ConnectionHandler.class).trace((Object)("Duration: " + duration + " ms"));
        }
    }

    private void printNCMap(Logger logger, NCMap map, String methodName, String prefix) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Ncomm: ");
        buffer.append(methodName);
        buffer.append(" ");
        buffer.append(prefix);
        buffer.append(":\n");
        buffer.append(map.toString());
        logger.trace((Object)buffer);
    }

    private boolean isTraceOptionSet(String traceOptionId) {
        return DO_TRACE;
    }
}

