/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.ncomm;

import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.internal.ncomm.MountOberver;
import com.adobe.drive.pipes.IPipe;
import com.adobe.drive.pipes.IPipeFactory;
import com.adobe.drive.pipes.IPipeServer;
import com.adobe.drive.pipes.Piper;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.host.HostController;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.osgi.framework.BundleContext;

class PipeConnector
implements Runnable {
    private static final int BUFFER_SIZE = 16384;
    private final BundleContext context;
    private final IPipeServer server;
    private int handlerCount = 0;
    private long timeToDie;

    public PipeConnector(BundleContext context, String pipeName) throws IOException {
        this.context = context;
        IPipeFactory fac = Piper.getFactory();
        this.server = fac.createStreamServer(pipeName, 16384, 16384);
        Thread t = new Thread((Runnable)this, "PipeConnector - " + pipeName);
        t.setDaemon(false);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        IPipe pipe = this.tryAccept();
        while (pipe != null) {
            try {
                PipeConnector pipeConnector = this;
                synchronized (pipeConnector) {
                    HostController.addConnection((InputStream)new BufferedInputStream(pipe.getInputStream(), 16384), (OutputStream)new BufferedOutputStream(pipe.getOutputStream(), 16384), (Runnable)new Runnable(){

                        public void run() {
                            PipeConnector.this.connectionClosed();
                        }
                    });
                    ++this.handlerCount;
                    this.notifyAll();
                }
            }
            catch (NativeCommException nce) {
                Logger.getLogger(this.getClass()).error((Object)this, (Throwable)nce);
            }
            pipe = this.tryAccept();
        }
    }

    public void stop() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {}
    }

    private IPipe tryAccept() {
        try {
            return this.server.accept();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectionClosed() {
        PipeConnector pipeConnector = this;
        synchronized (pipeConnector) {
            this.timeToDie = System.currentTimeMillis() + (long)this.getTimeout();
            if (this.handlerCount > 1 || MountOberver.areDrivesMounted()) {
                --this.handlerCount;
                return;
            }
            try {
                long now;
                Thread.currentThread().setName("Shall I Die?");
                while ((now = System.currentTimeMillis()) < this.timeToDie) {
                    this.wait(this.timeToDie - now);
                }
            }
            catch (InterruptedException interruptedException) {}
            --this.handlerCount;
            if (this.handlerCount == 0 && !MountOberver.areDrivesMounted()) {
                this.closeServer();
                try {
                    this.context.getBundle(0L).stop();
                }
                catch (Throwable throwable) {}
                System.exit(0);
            }
        }
    }

    private int getTimeout() {
        int timeout = Integer.getInteger("com.adobe.csi.ncomm.timeout", 5);
        return timeout * 60 * 1000;
    }

    private void closeServer() {
        try {
            this.server.close();
        }
        catch (IOException iOException) {}
    }
}

