/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.ncomm;

import com.adobe.csi.ncomm.PipeConnector;
import com.adobe.versioncue.nativecomm.host.HostController;
import java.io.File;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final String HOSTNAME = "localhost";
    private static final int LOCAL_PORT = 12345;
    private PipeConnector connector;

    public void start(BundleContext context) throws Exception {
        String pipename = this.getPipename();
        this.connector = new PipeConnector(context, pipename);
        if (this.useHTTP()) {
            HostController.startSocketListener((String)HOSTNAME, (int)12345);
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.useHTTP()) {
            HostController.stopSocketListener((String)HOSTNAME, (int)12345);
        }
        this.connector.stop();
        this.connector = null;
    }

    private String getPipename() {
        String user = System.getProperty("user.name");
        if (this.isMacOSX()) {
            String pipe = "/tmp/com.adobe.csi-CS4-" + user;
            File f = new File(pipe);
            f.delete();
            f.deleteOnExit();
            return pipe;
        }
        return "\\\\.\\pipe\\com.adobe.csi-CS4-" + user;
    }

    private boolean isMacOSX() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.startsWith("mac os x");
    }

    private boolean useHTTP() {
        Boolean useHttp = Boolean.getBoolean("com.adobe.csi.ncomm.useHTTP");
        return useHttp;
    }
}

