/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.ncomm;

import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.host.IRequest;
import com.adobe.versioncue.nativecomm.host.IRequestHandler;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

public class InvokeHandler
implements IRequestHandler {
    private static final String EXT_REQ_HANDLER = "EXTENSION_REQUEST_HANDLER";
    private static final Logger LOGGER = Logger.getLogger(InvokeHandler.class);
    private Map<String, ServiceReference> invocationHandlerMap = new ConcurrentHashMap<String, ServiceReference>();
    private ComponentContext context;

    public void handle(IRequest request) throws NativeCommException {
        try {
            NCMap params = request.getParams();
            String functionName = params.getString("csi.function");
            if (functionName == null) {
                LOGGER.error((Object)"missing parameter 'csi.function'");
                return;
            }
            ServiceReference reference = this.getService(functionName);
            if (reference == null) {
                LOGGER.error((Object)("unknown csi-function: " + functionName));
                return;
            }
            IExtensionInvocationHandler handler = (IExtensionInvocationHandler)this.context.locateService(EXT_REQ_HANDLER, reference);
            if (handler != null) {
                String req = params.getString("csi.request");
                String extensionId = params.getString("csi.serviceId");
                String rsp = handler.handle(extensionId, req);
                if (rsp != null) {
                    NCMap results = request.getResults();
                    results.put("response", rsp);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error((Object)"Caught exception.", (Throwable)e);
        }
    }

    protected void activate(ComponentContext context) {
        this.context = context;
    }

    protected void deactivate(ComponentContext context) {
        this.context = null;
    }

    protected void addExtensionInvocationHandler(ServiceReference serviceReference) {
        String function = (String)serviceReference.getProperty("csi.function");
        if (function != null) {
            this.invocationHandlerMap.put(function, serviceReference);
            LOGGER.info((Object)("Added ServiceReference for: " + function));
        }
    }

    protected void removeExtensionInvocationHandler(ServiceReference serviceReference) {
        String function = (String)serviceReference.getProperty("csi.function");
        if (function != null) {
            this.invocationHandlerMap.remove(function);
            LOGGER.info((Object)("Removed ServiceReference for: " + function));
        }
    }

    private ServiceReference getService(String functionName) {
        try {
            int i = 0;
            while (i < 40) {
                ServiceReference reference = this.invocationHandlerMap.get(functionName);
                if (reference != null) {
                    return reference;
                }
                Thread.sleep(500L);
                ++i;
            }
            LOGGER.error((Object)("getService() has timed out for: " + functionName));
        }
        catch (InterruptedException interruptedException) {
            LOGGER.error((Object)("getService() was interrupted waiting for: " + functionName));
        }
        return null;
    }
}

