/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.ncomm;

import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.core.ManifestEnum;
import com.adobe.csi.core.ServiceRegistryException;
import com.adobe.csi.core.logging.Logger;
import com.adobe.versioncue.nativecomm.NativeCommException;
import com.adobe.versioncue.nativecomm.host.IRequest;
import com.adobe.versioncue.nativecomm.host.IRequestHandler;
import com.adobe.versioncue.nativecomm.msg.NCMap;
import java.io.UnsupportedEncodingException;
import org.osgi.service.component.ComponentContext;

public class ConnectHandler
implements IRequestHandler {
    private static final Logger LOGGER = Logger.getLogger(ConnectHandler.class);
    private static final String NC_MAP_KEY_MANIFEST = "manifest";
    private static final String NC_MAP_KEY_VERSION = "version";
    private static final String SERVICE_REGISTRY = "SERVICE_REGISTRY";
    private ComponentContext context;

    public void handle(IRequest request) throws NativeCommException {
        NCMap params = request.getParams();
        NCMap results = request.getResults();
        int manifestVersion = params.getInt(NC_MAP_KEY_VERSION);
        ManifestEnum manifestEnum = ManifestEnum.getManifestEnum((int)manifestVersion);
        if (manifestEnum != null && manifestEnum == ManifestEnum.V_1_4) {
            byte[] manifest = this.getManifest(manifestEnum);
            results.put(NC_MAP_KEY_MANIFEST, manifest);
        } else {
            LOGGER.error((Object)("Unknown/Unsupported manifest-version: " + manifestVersion));
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        this.context = context;
    }

    protected void deactivate(ComponentContext context) {
        this.context = null;
    }

    private byte[] getManifest(ManifestEnum manifestEnum) {
        String manifest = null;
        IServiceRegistry serviceRegistry = (IServiceRegistry)this.context.locateService(SERVICE_REGISTRY);
        try {
            manifest = serviceRegistry.getManifestXML();
        }
        catch (ServiceRegistryException e) {
            LOGGER.error((Object)"Error while getting the manifest", (Throwable)e);
            return null;
        }
        try {
            byte[] result = manifest.getBytes("utf-8");
            return result;
        }
        catch (UnsupportedEncodingException e) {
            LOGGER.error((Object)"Error while getting the manifest", (Throwable)e);
            return null;
        }
    }
}

