/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension.ncomm;

import com.adobe.csi.extension.IManifestControllerService;
import com.adobe.csi.internal.extension.ncomm.StatusCode;
import com.adobe.csi.internal.extension.ncomm.UpdateExtensionsRequest;
import com.adobe.csi.internal.extension.ncomm.UpdateExtensionsRequestParser;
import com.adobe.csi.internal.extension.ncomm.UpdateExtensionsResponse;
import com.adobe.csi.internal.extension.ncomm.UpdateExtensionsResponseBuilder;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;

public class UpdateInvocationHandler
implements IExtensionInvocationHandler {
    private IManifestControllerService manifestControllerService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) throws Exception {
        UpdateExtensionsResponse updateExtensionsResponse = new UpdateExtensionsResponse();
        UpdateExtensionsRequest updateExtensionsRequest = null;
        try {
            updateExtensionsRequest = this.deserializeRequest(request);
            String urlString = updateExtensionsRequest.getUrl();
            URL url = new URL(urlString);
            this.manifestControllerService.checkForExtensionUpdates(url, true);
            updateExtensionsResponse.setStatus(StatusCode.ok);
        }
        catch (IOException e) {
            updateExtensionsResponse.setStatus(StatusCode.error);
            updateExtensionsResponse.setMessage(e.getMessage());
        }
        String result = null;
        try {
            result = this.serialize(updateExtensionsResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void bindManifestControllerService(IManifestControllerService manifestControllerService) {
        this.manifestControllerService = manifestControllerService;
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    protected void unbindManifestControllerService(IManifestControllerService manifestControllerService) {
        this.manifestControllerService = null;
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = null;
    }

    private UpdateExtensionsRequest deserializeRequest(String request) throws IOException {
        UpdateExtensionsRequest updateExtensionsRequest = null;
        UpdateExtensionsRequestParser updateExtensionsRequestParser = new UpdateExtensionsRequestParser(this.saxParserFactory);
        updateExtensionsRequest = updateExtensionsRequestParser.parse(new ByteArrayInputStream(request.getBytes("UTF-8")));
        return updateExtensionsRequest;
    }

    private String serialize(UpdateExtensionsResponse updateExtensionsResponse) throws IOException {
        UpdateExtensionsResponseBuilder builder = new UpdateExtensionsResponseBuilder();
        return builder.build(updateExtensionsResponse);
    }
}

