/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension.ncomm;

import com.adobe.csi.internal.extension.ncomm.UpdateExtensionsRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UpdateExtensionsRequestParser {
    private final SAXParserFactory saxParserFactory;

    public UpdateExtensionsRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public UpdateExtensionsRequest parse(InputStream request) throws IOException {
        UpdateExtensionsRequest updateExtensionsRequest = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(request, (DefaultHandler)handler);
            updateExtensionsRequest = handler.getUpdateExtensionsRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return updateExtensionsRequest;
    }

    private static class Handler
    extends DefaultHandler {
        private static final String XML_ELEMENT_UPDATE_EXTENSIONS_REQUEST = "updateExtensionsRequest";
        private static final String XML_ELEMENT_URL = "url";
        private ParserState parserState = ParserState.INITIAL;
        private UpdateExtensionsRequest updateExtensionsRequest;
        private final StringBuilder urlBuffer = new StringBuilder();

        Handler() {
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            switch (this.parserState) {
                case ELEMENT_URL: {
                    this.urlBuffer.append(new String(ch, start, length));
                }
            }
        }

        public void endDocument() throws SAXException {
            super.endDocument();
            if (this.urlBuffer.length() > 0) {
                this.updateExtensionsRequest.setUrl(this.urlBuffer.toString());
            }
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_UPDATE_EXTENSIONS_REQUEST: {
                    this.parserState = ParserState.DONE;
                    break;
                }
                case ELEMENT_URL: {
                    this.parserState = ParserState.ELEMENT_UPDATE_EXTENSIONS_REQUEST;
                    break;
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        public UpdateExtensionsRequest getUpdateExtensionsRequest() {
            return this.updateExtensionsRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    if (name.equals(XML_ELEMENT_UPDATE_EXTENSIONS_REQUEST)) {
                        this.updateExtensionsRequest = new UpdateExtensionsRequest();
                        this.parserState = ParserState.ELEMENT_UPDATE_EXTENSIONS_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_UPDATE_EXTENSIONS_REQUEST: {
                    if (name.equals(XML_ELEMENT_URL)) {
                        this.parserState = ParserState.ELEMENT_URL;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_URL: {
                    throw new SAXException("Invalid requestformat");
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            DONE,
            ELEMENT_UPDATE_EXTENSIONS_REQUEST,
            ELEMENT_URL,
            INITIAL;

        }
    }
}

