/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension.ncomm;

import com.adobe.csi.extension.IManifestControllerService;
import com.adobe.csi.internal.extension.ncomm.CleanUpExtensionsRequest;
import com.adobe.csi.internal.extension.ncomm.CleanUpExtensionsRequestParser;
import com.adobe.csi.internal.extension.ncomm.CleanUpExtensionsResponse;
import com.adobe.csi.internal.extension.ncomm.CleanUpExtensionsResponseBuilder;
import com.adobe.csi.internal.extension.ncomm.StatusCode;
import com.adobe.csi.ncomm.IExtensionInvocationHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.SAXParserFactory;

public class CleanUpInvocationHandler
implements IExtensionInvocationHandler {
    private IManifestControllerService manifestControllerService;
    private SAXParserFactory saxParserFactory;

    public String handle(String extensionId, String request) throws Exception {
        CleanUpExtensionsResponse cleanUpExtensionsResponse = new CleanUpExtensionsResponse();
        try {
            this.deserializeRequest(request);
            this.manifestControllerService.deleteSuperfluousVersions();
            cleanUpExtensionsResponse.setStatus(StatusCode.ok);
        }
        catch (IOException e) {
            cleanUpExtensionsResponse.setStatus(StatusCode.error);
            cleanUpExtensionsResponse.setMessage(e.getMessage());
        }
        String result = null;
        try {
            result = this.serialize(cleanUpExtensionsResponse);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return result;
    }

    protected void bindManifestControllerService(IManifestControllerService manifestControllerService) {
        this.manifestControllerService = manifestControllerService;
    }

    protected void bindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    protected void unbindManifestControllerService(IManifestControllerService manifestControllerService) {
        this.manifestControllerService = null;
    }

    protected void unbindSaxParserFactory(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = null;
    }

    private CleanUpExtensionsRequest deserializeRequest(String request) throws IOException {
        CleanUpExtensionsRequest cleanUpExtensionsRequest = null;
        CleanUpExtensionsRequestParser updateExtensionsRequestParser = new CleanUpExtensionsRequestParser(this.saxParserFactory);
        cleanUpExtensionsRequest = updateExtensionsRequestParser.parse(new ByteArrayInputStream(request.getBytes("UTF-8")));
        return cleanUpExtensionsRequest;
    }

    private String serialize(CleanUpExtensionsResponse cleanUpExtensionsResponse) throws IOException {
        CleanUpExtensionsResponseBuilder builder = new CleanUpExtensionsResponseBuilder();
        return builder.build(cleanUpExtensionsResponse);
    }
}

