/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension.ncomm;

import com.adobe.csi.internal.extension.ncomm.CleanUpExtensionsRequest;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CleanUpExtensionsRequestParser {
    private final SAXParserFactory saxParserFactory;

    public CleanUpExtensionsRequestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public CleanUpExtensionsRequest parse(InputStream request) throws IOException {
        CleanUpExtensionsRequest cleanUpExtensionsRequest = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(request, (DefaultHandler)handler);
            cleanUpExtensionsRequest = handler.getCleanUpExtensionsRequest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return cleanUpExtensionsRequest;
    }

    private static class Handler
    extends DefaultHandler {
        private static final String XML_ELEMENT_CLEAN_UP_EXTENSIONS_REQUEST = "cleanUpExtensionsRequest";
        private CleanUpExtensionsRequest cleanUpExtensionsRequest;
        private ParserState parserState = ParserState.INITIAL;

        Handler() {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_CLEAN_UP_EXTENSIONS_REQUEST: {
                    this.parserState = ParserState.DONE;
                    break;
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        public CleanUpExtensionsRequest getCleanUpExtensionsRequest() {
            return this.cleanUpExtensionsRequest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    if (name.equals(XML_ELEMENT_CLEAN_UP_EXTENSIONS_REQUEST)) {
                        this.cleanUpExtensionsRequest = new CleanUpExtensionsRequest();
                        this.parserState = ParserState.ELEMENT_CLEAN_UP_EXTENSIONS_REQUEST;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_CLEAN_UP_EXTENSIONS_REQUEST: {
                    throw new SAXException("Invalid requestformat");
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            DONE,
            ELEMENT_CLEAN_UP_EXTENSIONS_REQUEST,
            INITIAL;

        }
    }
}

