/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension.listener;

import com.adobe.csi.core.IManifestPersistenceService;
import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.core.IServiceRegistryListener;
import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.core.model.ExtensionBundle;
import com.adobe.csi.core.model.UserManifest;
import com.adobe.csi.internal.extension.listener.FallbackFileServiceRegistryListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.Formatter;
import java.util.Set;
import org.osgi.service.component.ComponentContext;

public class UpdatesTxtServiceRegistryListener
implements IServiceRegistryListener {
    private static final String LOCATION = String.valueOf(System.getProperty("user.dir")) + "/logs/updates.txt";
    private static final Logger LOGGER = Logger.getLogger(UpdatesTxtServiceRegistryListener.class);
    private IManifestPersistenceService manifestPersistenceService;
    private IServiceRegistry serviceRegistry;
    private File updatesFile;

    public void manifestChanged() {
        this.writeUpdatesFile();
    }

    protected void activate(ComponentContext context) throws Exception {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating IServiceRegistryListener: " + FallbackFileServiceRegistryListener.class));
        }
        this.updatesFile = new File(LOCATION);
    }

    protected void bindManifestPersistenceService(IManifestPersistenceService manifestPersistenceService) {
        this.manifestPersistenceService = manifestPersistenceService;
    }

    protected void bindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected void deactivate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deactivating IServiceRegistryListener: " + FallbackFileServiceRegistryListener.class));
        }
    }

    protected void unbindManifestPersistenceService(IManifestPersistenceService manifestPersistenceService) {
        this.manifestPersistenceService = null;
    }

    protected void unbindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = null;
    }

    private void writeUpdatesFile() {
        block29: {
            if (LOGGER.isLogging(Level.DEBUG)) {
                LOGGER.debug((Object)("Writing updates.txt: " + this.updatesFile));
            }
            BufferedWriter br = null;
            OutputStreamWriter wr = null;
            try {
                try {
                    if (!this.updatesFile.isFile()) {
                        this.updatesFile.getParentFile().mkdirs();
                        this.updatesFile.createNewFile();
                    }
                    UserManifest userManifest = this.manifestPersistenceService.loadUserManifest();
                    String etag = null;
                    long ttl = 0L;
                    Set extensionBundles = null;
                    if (userManifest != null) {
                        extensionBundles = userManifest.getExtensionBundles();
                        etag = userManifest.getEtag();
                        ttl = userManifest.getTtl();
                    } else {
                        extensionBundles = Collections.emptySet();
                        etag = "QUxMX1lPVVJfQkFTRV9BUkVfQkVMT05HX1RPX1VT";
                        ttl = 86400L;
                    }
                    StringBuilder buffer = new StringBuilder();
                    Formatter formatter = new Formatter(buffer);
                    formatter.format("Updated: %tc %n", System.currentTimeMillis());
                    formatter.format("ETAG   : %s %n", etag);
                    formatter.format("TTL    : %s %n", String.valueOf(ttl));
                    formatter.format("---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------%n", "");
                    formatter.format("| %1$-25s| %2$-35s| %3$-150s| %4$-150s|%n", "Id", "Version", "Directory", "URL");
                    formatter.format("|-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|%n", "");
                    for (ExtensionBundle extensionBundle : extensionBundles) {
                        formatter.format("| %1$-25s| %2$-35s| %3$-150s| %4$-150s|%n", extensionBundle.getExtensionBundleId(), extensionBundle.getVersion(), extensionBundle.getLocalUri(), extensionBundle.getRemoteUri());
                    }
                    formatter.format("---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------%n%n%n", "");
                    wr = new FileWriter(this.updatesFile, true);
                    br = new BufferedWriter(wr);
                    br.write(buffer.toString());
                    br.flush();
                }
                catch (IOException e) {
                    if (LOGGER.isLogging(Level.ERROR)) {
                        LOGGER.error((Object)("Error while writing updates.txt: " + e.getMessage()), (Throwable)e);
                    }
                    if (wr != null) {
                        try {
                            wr.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block29;
                }
            }
            catch (Throwable throwable) {
                if (wr != null) {
                    try {
                        wr.close();
                    }
                    catch (IOException iOException) {}
                }
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (wr != null) {
                try {
                    wr.close();
                }
                catch (IOException iOException) {}
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

