/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension.listener;

import com.adobe.csi.core.IManifestPersistenceService;
import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.core.IServiceRegistryListener;
import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.core.model.Manifest;
import org.osgi.service.component.ComponentContext;

public class ManifestPersistenceServiceRegistryListener
implements IServiceRegistryListener {
    static final Logger LOGGER = Logger.getLogger(ManifestPersistenceServiceRegistryListener.class);
    private IManifestPersistenceService manifestPersistenceService;
    private IServiceRegistry serviceRegistry;

    public void manifestChanged() {
        Manifest oldManifest;
        Manifest manifest = this.serviceRegistry.getManifest();
        if (!manifest.equals((Object)(oldManifest = this.manifestPersistenceService.loadManifest()))) {
            this.manifestPersistenceService.saveManifest(manifest);
        }
    }

    protected void activate(ComponentContext context) throws Exception {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating IServiceRegistryListener: " + ManifestPersistenceServiceRegistryListener.class));
        }
        this.manifestChanged();
    }

    protected void bindManifestPersistenceService(IManifestPersistenceService manifestPersistenceService) {
        this.manifestPersistenceService = manifestPersistenceService;
    }

    protected void bindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected void deactivate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deactivating IServiceRegistryListener: " + ManifestPersistenceServiceRegistryListener.class));
        }
    }

    protected void unbindManifestPersistenceService(IManifestPersistenceService manifestPersistenceService) {
        this.manifestPersistenceService = null;
    }

    protected void unbindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = null;
    }
}

