/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension.listener;

import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.core.IServiceRegistryListener;
import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.core.model.Extension;
import com.adobe.csi.core.model.ExtensionDispatchInfo;
import com.adobe.csi.core.model.Manifest;
import com.adobe.csi.internal.extension.ExtensionUtilties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashSet;
import org.osgi.service.component.ComponentContext;

public class FlashplayerTrustServiceRegistryListener
implements IServiceRegistryListener {
    private static final Logger LOGGER = Logger.getLogger(FlashplayerTrustServiceRegistryListener.class);
    private static final String TYPE_TRUSTED = "Trusted";
    private File flashPlayerTrustFile;
    private IServiceRegistry serviceRegistry;

    public void manifestChanged() {
        this.writeFlashPlayerTrustFile();
    }

    protected void activate(ComponentContext context) throws Exception {
        boolean mkDirs;
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating IServiceRegistryListener: " + FlashplayerTrustServiceRegistryListener.class));
        }
        File flashPlayerTrusDir = null;
        if (this.isWin()) {
            flashPlayerTrusDir = new File(ExtensionUtilties.getUserExtensionDirectory(), "../../../Macromedia/Flash Player/#Security/FlashPlayerTrust/");
        } else if (this.isMac()) {
            flashPlayerTrusDir = new File(ExtensionUtilties.getUserExtensionDirectory(), "../../../../Preferences/Macromedia/Flash Player/#Security/FlashPlayerTrust/");
        } else {
            throw new Exception("Unknown OS");
        }
        if (!flashPlayerTrusDir.exists() && !(mkDirs = flashPlayerTrusDir.mkdirs())) {
            throw new Exception("Directory could not be created: " + flashPlayerTrusDir);
        }
        this.flashPlayerTrustFile = new File(flashPlayerTrusDir, "AdobeExtensions.cfg");
        this.writeFlashPlayerTrustFile();
    }

    protected void bindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected void deactivate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deactivating IServiceRegistryListener: " + FlashplayerTrustServiceRegistryListener.class));
        }
    }

    protected void unbindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = null;
    }

    private boolean isMac() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("mac");
    }

    private boolean isWin() {
        String osName = System.getProperty("os.name");
        return osName.toLowerCase().contains("win");
    }

    private void writeFlashPlayerTrustFile() {
        block21: {
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)"Writing Flashplayer trust file");
            }
            HashSet<File> trustedLocations = new HashSet<File>();
            Manifest manifest = this.serviceRegistry.getManifest();
            Extension[] extensions = manifest.getExtensions().getExtensions();
            ExtensionDispatchInfo[] dispatchInfos = manifest.getDispatchList().getExtensionDispatchInfos();
            Extension[] extensionArray = extensions;
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                Extension extension = extensionArray[n2];
                if (extension.getType() != null && extension.getType().equalsIgnoreCase(TYPE_TRUSTED)) {
                    String extensionId = extension.getExtensionId();
                    ExtensionDispatchInfo[] extensionDispatchInfoArray = dispatchInfos;
                    int n3 = dispatchInfos.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        ExtensionDispatchInfo dispatchInfo = extensionDispatchInfoArray[n4];
                        if (dispatchInfo.getExtensionId().equals(extensionId)) {
                            File swfFilePath = new File(String.valueOf(ExtensionUtilties.getUserExtensionDirectory()) + "/" + dispatchInfo.getSwfPath());
                            trustedLocations.add(swfFilePath);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            if (!trustedLocations.isEmpty()) {
                Writer w = null;
                try {
                    try {
                        w = new OutputStreamWriter((OutputStream)new FileOutputStream(this.flashPlayerTrustFile), "UTF-8");
                        for (File trustedLocation : trustedLocations) {
                            w.write(trustedLocation.getCanonicalPath());
                            w.write(10);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Failed to create Flash Player Trust File.", (Throwable)e);
                        if (w != null) {
                            try {
                                w.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    if (w != null) {
                        try {
                            w.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (w != null) {
                    try {
                        w.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

