/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension.listener;

import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.core.IServiceRegistryListener;
import com.adobe.csi.core.ServiceRegistryException;
import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.FileChannel;
import org.osgi.service.component.ComponentContext;

public class FallbackFileServiceRegistryListener
implements IServiceRegistryListener {
    private static final Logger LOGGER = Logger.getLogger(FallbackFileServiceRegistryListener.class);
    private File fallbackDir;
    private IServiceRegistry serviceRegistry;

    public void manifestChanged() {
        this.writeManifest();
    }

    protected void activate(ComponentContext context) throws Exception {
        boolean mkDirs;
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating IServiceRegistryListener: " + FallbackFileServiceRegistryListener.class));
        }
        this.fallbackDir = new File(String.valueOf(System.getProperty("user.dir")) + "/");
        if (!this.fallbackDir.exists() && !(mkDirs = this.fallbackDir.mkdirs())) {
            throw new Exception("Directory could not be created: " + this.fallbackDir);
        }
        this.writeManifest();
    }

    protected void bindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected void deactivate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deactivating IServiceRegistryListener: " + FallbackFileServiceRegistryListener.class));
        }
    }

    protected void unbindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = null;
    }

    private void renameFile(File oldFile, File newFile) throws IOException {
        FileChannel fcOld = new FileInputStream(oldFile).getChannel();
        FileChannel fcNew = new FileOutputStream(newFile).getChannel();
        try {
            fcNew.transferFrom(fcOld, 0L, fcOld.size());
        }
        catch (Throwable throwable) {
            try {
                fcOld.close();
            }
            catch (IOException iOException) {}
            try {
                fcNew.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            fcOld.close();
        }
        catch (IOException iOException) {}
        try {
            fcNew.close();
        }
        catch (IOException iOException) {}
        oldFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeManifest() {
        Class<FallbackFileServiceRegistryListener> clazz = FallbackFileServiceRegistryListener.class;
        synchronized (FallbackFileServiceRegistryListener.class) {
            try {
                String xml = this.serviceRegistry.getManifestXML();
                File tmpManifest = new File(this.fallbackDir, "ServiceManifest.tmp");
                this.writeTmpManifest(tmpManifest, xml);
                File newManifest = new File(this.fallbackDir, "ServiceManifest.xml");
                this.renameFile(tmpManifest, newManifest);
                if (LOGGER.isLogging(Level.INFO)) {
                    LOGGER.info((Object)("Fallback-Manifest written: " + newManifest));
                }
            }
            catch (ServiceRegistryException e) {
                LOGGER.error((Object)"Exception while trying to write the fallback file", (Throwable)e);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Exception while trying to write the fallback file", (Throwable)e);
            }
            return;
        }
    }

    private void writeTmpManifest(File tmpManifest, String content) throws IOException {
        BufferedWriter bufferedWriter = null;
        try {
            FileOutputStream fos = new FileOutputStream(tmpManifest);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            bufferedWriter = new BufferedWriter(osw);
            bufferedWriter.write(content);
            bufferedWriter.flush();
        }
        catch (Throwable throwable) {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (bufferedWriter != null) {
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {}
        }
    }
}

