/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension.listener;

import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.core.IServiceRegistryListener;
import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.core.model.Extension;
import com.adobe.csi.core.model.Extensions;
import com.adobe.csi.core.model.Manifest;
import com.adobe.csi.core.model.Preference;
import com.adobe.csi.core.model.Preferences;
import com.adobe.csi.preference.IPreferenceService;
import com.adobe.csi.preference.PreferenceServiceException;
import com.adobe.csi.preference.PreferenceType;
import org.osgi.service.component.ComponentContext;

public class DefaultPreferencesServiceRegistryListener
implements IServiceRegistryListener {
    private static final Logger LOGGER = Logger.getLogger(DefaultPreferencesServiceRegistryListener.class);
    private IPreferenceService preferenceService;
    private IServiceRegistry serviceRegistry;

    public void manifestChanged() {
        this.storeDefaultPreferences();
    }

    protected void activate(ComponentContext context) throws Exception {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating IServiceRegistryListener: " + DefaultPreferencesServiceRegistryListener.class));
        }
        this.storeDefaultPreferences();
    }

    protected void bindPreferenceService(IPreferenceService preferenceService) {
        this.preferenceService = preferenceService;
    }

    protected void bindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    protected void deactivate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deactivating IServiceRegistryListener: " + DefaultPreferencesServiceRegistryListener.class));
        }
    }

    protected void unbindPreferenceService(IPreferenceService preferenceService) {
        this.preferenceService = null;
    }

    protected void unbindServiceRegistry(IServiceRegistry serviceRegistry) {
        this.serviceRegistry = null;
    }

    private void storeDefaultPreferences() {
        assert (this.serviceRegistry != null) : "serviceRegistry == null";
        assert (this.preferenceService != null) : "preferenceService == null";
        Manifest manifest = this.serviceRegistry.getManifest();
        Extensions extensions = manifest.getExtensions();
        Extension[] extensionArray = extensions.getExtensions();
        int n = extensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Extension extension = extensionArray[n2];
            String user = extension.getExtensionId();
            Preferences preferences = extension.getPreferences();
            if (preferences != null) {
                Preference[] prefs;
                Preference[] preferenceArray = prefs = preferences.getPreferences();
                int n3 = prefs.length;
                int n4 = 0;
                while (n4 < n3) {
                    block10: {
                        Preference preference = preferenceArray[n4];
                        String key = preference.getKey();
                        PreferenceType type = null;
                        PreferenceType[] preferenceTypeArray = PreferenceType.values();
                        int n5 = preferenceTypeArray.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            PreferenceType current = preferenceTypeArray[n6];
                            if (current.toString().equals(preference.getType().toString())) {
                                type = current;
                                break;
                            }
                            ++n6;
                        }
                        String value = preference.getValue();
                        try {
                            if (LOGGER.isLogging(Level.INFO)) {
                                LOGGER.info((Object)("Storing default preference for " + user + " (" + key + " => " + value + ")"));
                            }
                            this.preferenceService.storeDefaultPreference(user, key, value, type);
                        }
                        catch (PreferenceServiceException e) {
                            if (!LOGGER.isLogging(Level.ERROR)) break block10;
                            LOGGER.error((Object)"Error while storing default preference", (Throwable)e);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

