/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension;

import com.adobe.csi.core.model.ExtensionBundle;
import com.adobe.csi.core.model.UserManifest;
import java.io.IOException;
import java.io.InputStream;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class UserManifestParser {
    private final SAXParserFactory saxParserFactory;

    public UserManifestParser(SAXParserFactory saxParserFactory) {
        this.saxParserFactory = saxParserFactory;
    }

    public UserManifest parse(InputStream request) throws IOException {
        UserManifest userManifest = null;
        try {
            SAXParser saxParser = this.saxParserFactory.newSAXParser();
            Handler handler = new Handler();
            saxParser.parse(request, (DefaultHandler)handler);
            userManifest = handler.getUserManifest();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        return userManifest;
    }

    private static class Handler
    extends DefaultHandler {
        private static final String XML_ATTRIBUTE_ETAG = "ETag";
        private static final String XML_ATTRIBUTE_ID = "Id";
        private static final String XML_ATTRIBUTE_TTL = "TTL";
        private static final String XML_ATTRIBUTE_URL = "URL";
        private static final String XML_ATTRIBUTE_VERSION = "Version";
        private static final String XML_ELEMENT_EXTENSION_BUNDLE = "ExtensionBundle";
        private static final String XML_ELEMENT_EXTENSION_BUNDLES = "ExtensionBundles";
        private static final String XML_ELEMENT_USER_MANIFEST = "UserManifest";
        private Set<ExtensionBundle> extensionBundles;
        private ParserState parserState = ParserState.INITIAL;
        private UserManifest userManifest;

        Handler() {
        }

        public void endElement(String uri, String localName, String name) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_USER_MANIFEST: {
                    this.parserState = ParserState.DONE;
                    break;
                }
                case ELEMENT_EXTENSION_BUNDLES: {
                    this.parserState = ParserState.ELEMENT_USER_MANIFEST;
                    break;
                }
                case ELEMENT_EXTENSION_BUNDLE: {
                    this.parserState = ParserState.ELEMENT_EXTENSION_BUNDLES;
                    break;
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        public UserManifest getUserManifest() {
            this.userManifest.setExtensionBundles(this.extensionBundles);
            return this.userManifest;
        }

        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            switch (this.parserState) {
                case INITIAL: {
                    if (name.equals(XML_ELEMENT_USER_MANIFEST)) {
                        this.userManifest = new UserManifest();
                        this.extensionBundles = new TreeSet<ExtensionBundle>();
                        String ttl = attributes.getValue(XML_ATTRIBUTE_TTL);
                        String eTag = attributes.getValue(XML_ATTRIBUTE_ETAG);
                        this.userManifest.setTtl(Long.parseLong(ttl));
                        this.userManifest.setEtag(eTag);
                        this.parserState = ParserState.ELEMENT_USER_MANIFEST;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_USER_MANIFEST: {
                    if (name.equals(XML_ELEMENT_EXTENSION_BUNDLES)) {
                        this.parserState = ParserState.ELEMENT_EXTENSION_BUNDLES;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_EXTENSION_BUNDLES: {
                    if (name.equals(XML_ELEMENT_EXTENSION_BUNDLE)) {
                        String extensionBundleId = attributes.getValue(XML_ATTRIBUTE_ID);
                        String version = attributes.getValue(XML_ATTRIBUTE_VERSION);
                        String url = attributes.getValue(XML_ATTRIBUTE_URL);
                        ExtensionBundle extensionBundle = new ExtensionBundle();
                        extensionBundle.setExtensionBundleId(extensionBundleId);
                        extensionBundle.setVersion(version);
                        extensionBundle.setRemoteUri(url);
                        this.extensionBundles.add(extensionBundle);
                        this.parserState = ParserState.ELEMENT_EXTENSION_BUNDLE;
                        break;
                    }
                    throw new SAXException("Invalid requestformat");
                }
                case ELEMENT_EXTENSION_BUNDLE: {
                    throw new SAXException("Invalid requestformat");
                }
                case DONE: {
                    throw new SAXException("Invalid requestformat");
                }
                default: {
                    throw new SAXException("Unhandeld parser state: " + (Object)((Object)this.parserState));
                }
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum ParserState {
            DONE,
            ELEMENT_EXTENSION_BUNDLE,
            ELEMENT_EXTENSION_BUNDLES,
            ELEMENT_USER_MANIFEST,
            INITIAL;

        }
    }
}

