/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension;

import com.adobe.csi.core.IManifestPersistenceService;
import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.core.ServiceRegistryException;
import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.core.model.ExtensionBundle;
import com.adobe.csi.core.model.Manifest;
import com.adobe.csi.core.model.ServiceManifestException;
import com.adobe.csi.core.model.ServiceModelFacade;
import com.adobe.csi.core.model.UpdateSite;
import com.adobe.csi.core.model.UserManifest;
import com.adobe.csi.internal.extension.ExtensionUtilties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import javax.xml.parsers.SAXParserFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManifestUpdateThread {
    private static Object lock = new Object();
    private static final Logger LOGGER = Logger.getLogger(ManifestUpdateThread.class);
    private static final int MAX_VERSION_COUNT = 1;
    private IManifestPersistenceService manifestPersistenceService;
    private boolean online;
    private URL ozzyURL;
    private SAXParserFactory saxParserFactory;
    private IServiceRegistry serviceRegistry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForExtensionUpdates(IManifestPersistenceService manifestPersistenceService, IServiceRegistry serviceRegistry, URL ozzyURL, SAXParserFactory saxParserFactory, boolean online) {
        Object object = lock;
        synchronized (object) {
            Date date;
            block7: {
                this.manifestPersistenceService = manifestPersistenceService;
                this.serviceRegistry = serviceRegistry;
                this.ozzyURL = ozzyURL;
                this.saxParserFactory = saxParserFactory;
                this.online = online;
                date = new Date();
                if (LOGGER.isLogging(Level.INFO)) {
                    LOGGER.info((Object)("Starting update cycle at: " + date.toString()));
                }
                try {
                    this.startUpdateCycle();
                }
                catch (Exception e) {
                    if (!LOGGER.isLogging(Level.ERROR)) break block7;
                    LOGGER.error((Object)("Error during update cycle: " + e.getMessage()), (Throwable)e);
                }
            }
            date = new Date();
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Ended update cycle at: " + date.toString()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteSuperfluousVersions(IManifestPersistenceService manifestPersistenceService) {
        Object object = lock;
        synchronized (object) {
            this.manifestPersistenceService = manifestPersistenceService;
            Date date = new Date();
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Starting clean up cycle at: " + date.toString()));
            }
            this.deleteSuperfluousVersionsImpl();
            date = new Date();
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Ended clean up at: " + date.toString()));
            }
        }
    }

    private void addLocalUriInfo(UserManifest oldUserManifest, UserManifest newUserManifest) {
        Set newExtensionBundleSet = newUserManifest.getExtensionBundles();
        Set oldExtensionBundleSet = oldUserManifest.getExtensionBundles();
        block0: for (ExtensionBundle newExtensionBundle : newExtensionBundleSet) {
            String newExtensionBundleId = newExtensionBundle.getExtensionBundleId();
            String newVersion = newExtensionBundle.getVersion();
            for (ExtensionBundle oldExtensionBundle : oldExtensionBundleSet) {
                String oldExtensionBundleId = oldExtensionBundle.getExtensionBundleId();
                String oldVersion = oldExtensionBundle.getVersion();
                if (!oldExtensionBundleId.equals(newExtensionBundleId) || oldVersion == null || !oldVersion.equals(newVersion)) continue;
                newExtensionBundle.setLocalUri(oldExtensionBundle.getLocalUri());
                continue block0;
            }
        }
    }

    private Manifest addManifestFile(File extensionManifestFile, Manifest manifest) {
        Manifest manifestResult;
        block8: {
            manifestResult = null;
            if (extensionManifestFile.isFile()) {
                if (LOGGER.isLogging(Level.INFO)) {
                    LOGGER.info((Object)("Picking up extension manifest: " + extensionManifestFile.getAbsolutePath()));
                }
                try {
                    FileInputStream is = new FileInputStream(extensionManifestFile);
                    InputStreamReader extensionManifestReader = new InputStreamReader((InputStream)is, "UTF-8");
                    InputStreamReader extensionManifestSchema = new InputStreamReader(this.serviceRegistry.getExtensionManifestSchema().openStream());
                    String relativePathSegment = this.extractRelativePathSegment(extensionManifestFile);
                    Manifest manifestClone = manifest.clone();
                    ServiceModelFacade.addExtensionManifest((Reader)extensionManifestReader, (Reader)extensionManifestSchema, (Manifest)manifestClone, (String)relativePathSegment);
                    manifestResult = manifestClone;
                }
                catch (ServiceManifestException e) {
                    if (LOGGER.isLogging(Level.ERROR)) {
                        LOGGER.error((Object)("Error while adding extension manifest from: " + extensionManifestFile.getAbsolutePath() + ": " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (FileNotFoundException e) {
                    if (LOGGER.isLogging(Level.ERROR)) {
                        LOGGER.error((Object)("File with extension manifest not valid: " + extensionManifestFile.getAbsolutePath() + ": " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (IOException e) {
                    if (!LOGGER.isLogging(Level.ERROR)) break block8;
                    LOGGER.error((Object)("Error while adding extension manifest from: " + extensionManifestFile.getAbsolutePath() + ": " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return manifestResult;
    }

    private boolean checkExtensionIntegrity(ExtensionBundle extensionBundle) {
        URI uri;
        File file;
        boolean integrity = false;
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Checking integrity of extensions: " + extensionBundle.getExtensionBundleId() + " (" + extensionBundle.getVersion() + ")"));
        }
        if ((file = new File(uri = URI.create(extensionBundle.getLocalUri()))).isDirectory()) {
            integrity = true;
        }
        return integrity;
    }

    private void copyExtension(File src, File dest) throws IOException {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Copying extension from \"" + src + "\" to \"" + dest + "\""));
        }
        try {
            ExtensionUtilties.copyFiles(src, dest);
        }
        catch (IOException e) {
            if (LOGGER.isLogging(Level.ERROR)) {
                LOGGER.error((Object)("Error while copying extension: " + e.getMessage()), (Throwable)e);
            }
            throw e;
        }
    }

    private ExtensionBundle createExtensionBundle(String extensionBundleId, String localUri, String remoteUri, String version) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Creating extension bundle for: " + extensionBundleId));
        }
        ExtensionBundle extensionBundle = new ExtensionBundle();
        extensionBundle.setExtensionBundleId(extensionBundleId);
        extensionBundle.setRemoteUri(remoteUri);
        extensionBundle.setLocalUri(localUri);
        extensionBundle.setVersion(version);
        return extensionBundle;
    }

    private File createTempDir(File parentDir) {
        File tmpDir = new File(parentDir, UUID.randomUUID().toString());
        tmpDir.mkdirs();
        tmpDir.deleteOnExit();
        if (LOGGER.isLogging(Level.DEBUG)) {
            LOGGER.debug((Object)("Created temp directory: " + tmpDir));
        }
        return tmpDir;
    }

    private void deflateZip(File zipFile, File destination) throws IOException {
        if (zipFile.isFile() && zipFile.getName().toLowerCase().endsWith(".zip")) {
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Deflating zip file: " + zipFile));
            }
            try {
                ExtensionUtilties.unzip(zipFile, destination);
            }
            catch (IOException e) {
                block7: {
                    if (LOGGER.isLogging(Level.ERROR)) {
                        LOGGER.error((Object)("Error while deflating file: " + e.getMessage()), (Throwable)e);
                    }
                    try {
                        ExtensionUtilties.deleteFiles(destination);
                    }
                    catch (IOException iOException) {
                        if (!LOGGER.isLogging(Level.ERROR)) break block7;
                        LOGGER.error((Object)("Error while deleting file: " + e.getMessage()), (Throwable)e);
                    }
                }
                throw e;
            }
        }
    }

    private void deleteSuperfluousVersionsImpl() {
        UserManifest[] userManifests;
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)"Checking for old versions which can be deleted");
        }
        if ((userManifests = this.manifestPersistenceService.loadUserManifests()).length > 1) {
            HashSet<String> extensionDirs = new HashSet<String>();
            int i = 0;
            while (i < userManifests.length - 1) {
                UserManifest userManifest = userManifests[i];
                Set extensionBundles = userManifest.getExtensionBundles();
                for (ExtensionBundle extensionBundle : extensionBundles) {
                    extensionDirs.add(extensionBundle.getLocalUri());
                }
                this.manifestPersistenceService.deleteUserManifest(userManifest);
                ++i;
            }
            Set extensionBundles = userManifests[userManifests.length - 1].getExtensionBundles();
            for (ExtensionBundle extensionBundle : extensionBundles) {
                extensionDirs.remove(extensionBundle.getLocalUri());
            }
            for (String extensionBundleDir : extensionDirs) {
                File deleteVersionDir = new File(URI.create(extensionBundleDir));
                try {
                    if (LOGGER.isLogging(Level.INFO)) {
                        LOGGER.info((Object)("Delting version directory: " + deleteVersionDir));
                    }
                    ExtensionUtilties.deleteFiles(deleteVersionDir);
                }
                catch (IOException e) {
                    if (!LOGGER.isLogging(Level.ERROR)) continue;
                    LOGGER.error((Object)("Error while delting version directory (" + deleteVersionDir + "): " + e.getMessage()), (Throwable)e);
                }
            }
        }
        this.setClearExtensionsFlag(false);
    }

    private void deleteUserExtensionDir() throws IOException {
        File userExtensionDir = new File(ExtensionUtilties.getUserExtensionDirectory());
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deleting user extension directory: " + userExtensionDir));
        }
        try {
            if (userExtensionDir.isDirectory()) {
                ExtensionUtilties.deleteFiles(userExtensionDir);
            }
        }
        catch (IOException e) {
            if (LOGGER.isLogging(Level.ERROR)) {
                LOGGER.error((Object)("Error while deleting user extension directory: " + e.getMessage()), (Throwable)e);
            }
            throw e;
        }
    }

    private File downloadExtensionBundle(ExtensionBundle extensionBundle, File destination) throws IOException {
        File zip = null;
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Downloading extension bundle for \"" + extensionBundle.getExtensionBundleId() + "\" from: " + extensionBundle.getRemoteUri()));
        }
        try {
            URI uri = new URI(extensionBundle.getRemoteUri());
            zip = new File(destination + "/" + UUID.randomUUID().toString() + ".zip");
            ExtensionUtilties.downloadFile(uri.toURL(), zip);
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
        return zip;
    }

    private String extractRelativePathSegment(File manifestFile) {
        String relativePathSegment = "";
        String absolutFile = manifestFile.getAbsolutePath();
        String userExtensionDirectory = ExtensionUtilties.getUserExtensionDirectory();
        relativePathSegment = absolutFile.substring(userExtensionDirectory.length());
        relativePathSegment = relativePathSegment.substring(0, relativePathSegment.length() - "META-INF/manifest.xml".length());
        relativePathSegment = relativePathSegment.replaceAll("\\\\", "/");
        relativePathSegment = relativePathSegment.replaceAll("/+", "/");
        return relativePathSegment;
    }

    private List<ExtensionBundle> getNewExtensionBundles(UserManifest oldUserManifest, UserManifest newUserManifest) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)"Analyzing new user manifest");
        }
        LinkedList<ExtensionBundle> newExtensionBundleList = new LinkedList<ExtensionBundle>();
        if (newUserManifest != null) {
            Set newExtensionBundleSet = newUserManifest.getExtensionBundles();
            Set oldExtensionBundleSet = oldUserManifest.getExtensionBundles();
            for (ExtensionBundle newExtensionBundle : newExtensionBundleSet) {
                String newExtensionBundleId = newExtensionBundle.getExtensionBundleId();
                String newVersion = newExtensionBundle.getVersion();
                boolean update = true;
                for (ExtensionBundle oldExtensionBundle : oldExtensionBundleSet) {
                    String oldExtensionBundleId = oldExtensionBundle.getExtensionBundleId();
                    String oldVersion = oldExtensionBundle.getVersion();
                    if (!oldExtensionBundleId.equals(newExtensionBundleId)) continue;
                    if (oldVersion == null || !oldVersion.equals(newVersion)) break;
                    update = false;
                    break;
                }
                if (!update) continue;
                newExtensionBundleList.add(newExtensionBundle);
            }
        }
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Found " + newExtensionBundleList.size() + " extension bundles to update"));
        }
        return newExtensionBundleList;
    }

    private UserManifest handleInitialInstall() throws IOException {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)"Performing initial install routine for extensions");
        }
        UserManifest userManifest = new UserManifest();
        userManifest.setTtl(86400L);
        userManifest.setEtag("QUxMX1lPVVJfQkFTRV9BUkVfQkVMT05HX1RPX1VT");
        this.deleteUserExtensionDir();
        File installExtensionDir = new File(ExtensionUtilties.getExtensionDirectory());
        if (!installExtensionDir.isDirectory()) {
            throw new IOException("The installation directory could not be found");
        }
        File[] fileArray = installExtensionDir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                File extensionDir = fileArray[n2];
                if (this.isValidExtensionDir(extensionDir)) {
                    try {
                        File manifestFile = ExtensionUtilties.getManifestFile(extensionDir);
                        String extensionBundleId = ExtensionUtilties.getExtensionBundleId(manifestFile);
                        String extensionBundleVersion = ExtensionUtilties.getExtensionBundleVersion(manifestFile);
                        if (extensionBundleVersion == null) {
                            extensionBundleVersion = "NO_VERSION_INFO_AVAILABLE";
                        }
                        if (extensionBundleId != null) {
                            File userExtensionDir = ExtensionUtilties.getNextVersionExtensionDir(extensionBundleId);
                            this.copyExtension(extensionDir, userExtensionDir);
                            ExtensionBundle extensionBundle = this.createExtensionBundle(extensionBundleId, userExtensionDir.toURI().toString(), extensionDir.toURI().toString(), extensionBundleVersion);
                            userManifest.getExtensionBundles().add(extensionBundle);
                        } else if (LOGGER.isLogging(Level.ERROR)) {
                            LOGGER.error((Object)("No valid extension bundle id could be found in: " + manifestFile));
                        }
                    }
                    catch (IOException e) {
                        if (!LOGGER.isLogging(Level.ERROR)) break block10;
                        LOGGER.error((Object)("Error while adding extension from \"" + extensionDir + "\": " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            ++n2;
        }
        this.saveUserManifest(userManifest);
        this.rebuildManifest(userManifest);
        return userManifest;
    }

    private boolean isOnlineEnabled() {
        return this.online;
    }

    private boolean isValidExtensionDir(File extensionDir) {
        boolean isValid = false;
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Checking if is a valid extension dir: " + extensionDir));
        }
        if (extensionDir.isDirectory()) {
            isValid = ExtensionUtilties.hasValidExtensionStructure(extensionDir);
        }
        return isValid;
    }

    private UserManifest loadUserManifestFromDB() {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)"Loading user manifest");
        }
        return this.manifestPersistenceService.loadUserManifest();
    }

    private UserManifest loadUserManifestFromOzzy() {
        UserManifest userManifest;
        block4: {
            userManifest = null;
            if (this.ozzyURL != null) {
                if (LOGGER.isLogging(Level.INFO)) {
                    LOGGER.info((Object)("Connecting to Ozzy-update-server for user manifest: " + this.ozzyURL));
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    ExtensionUtilties.downloadFile(this.ozzyURL, baos);
                    String userManifestXML = baos.toString("UTF-8");
                    userManifest = ExtensionUtilties.parseUserManifest(userManifestXML, this.saxParserFactory);
                }
                catch (IOException e) {
                    if (!LOGGER.isLogging(Level.ERROR)) break block4;
                    LOGGER.error((Object)("Failed to retrieve user manifest: " + e.getMessage()), (Throwable)e);
                }
            }
        }
        return userManifest;
    }

    private void rebuildManifest(UserManifest userManifest) {
        File[] extensionManifestFiles;
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)"Rebuilding manifest from user manifest");
        }
        UpdateSite updateSite = new UpdateSite(this.ozzyURL != null ? this.ozzyURL.toString() : "", userManifest.getTtl(), userManifest.getEtag());
        Manifest manifest = this.serviceRegistry.createNewManifest(updateSite);
        File[] fileArray = extensionManifestFiles = ExtensionUtilties.collectNewestExtensionManifests(userManifest);
        int n = extensionManifestFiles.length;
        int n2 = 0;
        while (n2 < n) {
            block6: {
                File extensionManifestFile = fileArray[n2];
                Manifest newManifest = this.addManifestFile(extensionManifestFile, manifest);
                if (newManifest != null) {
                    manifest = newManifest;
                } else {
                    File extensionDirectory = extensionManifestFile.getParentFile().getParentFile();
                    try {
                        ExtensionUtilties.deleteFiles(extensionDirectory);
                    }
                    catch (IOException e) {
                        if (!LOGGER.isLogging(Level.ERROR)) break block6;
                        LOGGER.error((Object)("Error while deleting errornous extension directory: " + e.getMessage()), (Throwable)e);
                    }
                }
            }
            ++n2;
        }
        this.setNewManifest(manifest);
    }

    private void saveUserManifest(UserManifest userManifest) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)"Saving user manifest");
        }
        this.manifestPersistenceService.saveUserManifest(userManifest);
    }

    private void setClearExtensionsFlag(boolean clearExtensions) {
        block3: {
            if (LOGGER.isLogging(Level.INFO)) {
                LOGGER.info((Object)("Setting the clear versions flag to " + clearExtensions));
            }
            try {
                Properties properties = ExtensionUtilties.getAgentProperties();
                properties.setProperty("clearExtensions", Boolean.toString(clearExtensions));
                ExtensionUtilties.setAgentProperties(properties);
            }
            catch (IOException e) {
                if (!LOGGER.isLogging(Level.ERROR)) break block3;
                LOGGER.error((Object)("Error while setting the clear versions flag: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private void setNewManifest(Manifest manifest) {
        block5: {
            Object lock = new Object();
            try {
                this.serviceRegistry.acquireLock(lock);
                this.serviceRegistry.replaceManifest(manifest, lock);
                this.serviceRegistry.releaseLock(lock);
            }
            catch (ServiceRegistryException e) {
                if (LOGGER.isLogging(Level.ERROR)) {
                    LOGGER.error((Object)("Error while replacing manifest: " + e.getMessage()), (Throwable)e);
                }
                if (!this.serviceRegistry.isLockOwner(lock)) break block5;
                try {
                    this.serviceRegistry.rollback(lock);
                }
                catch (ServiceRegistryException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private synchronized void startUpdateCycle() throws IOException {
        block13: {
            tempDir = this.createTempDir(new File(System.getProperty("java.io.tmpdir")));
            try {
                userManifest = this.loadUserManifestFromDB();
                if (userManifest == null) {
                    userManifest = this.handleInitialInstall();
                }
                userManifest = userManifest.clone();
                extensionBundleSet = userManifest.getExtensionBundles();
                iterator = extensionBundleSet.iterator();
                needsUpdate = false;
                while (iterator.hasNext()) {
                    extensionBundle = (ExtensionBundle)iterator.next();
                    integrity = this.checkExtensionIntegrity(extensionBundle);
                    if (integrity) continue;
                    iterator.remove();
                    needsUpdate = true;
                }
                if (needsUpdate) {
                    this.saveUserManifest(userManifest);
                    this.rebuildManifest(userManifest);
                }
                if (!this.isOnlineEnabled()) break block13;
                newUserManifest = this.loadUserManifestFromOzzy();
                newExtensionBundleList = this.getNewExtensionBundles(userManifest, newUserManifest);
                needsUpdate = false;
                block6: for (ExtensionBundle extensionBundle : newExtensionBundleList) {
                    try {
                        tmpExtensionFile = this.downloadExtensionBundle(extensionBundle, tempDir);
                        tmpExtensionDir = this.createTempDir(tempDir);
                        this.deflateZip(tmpExtensionFile, tmpExtensionDir);
                        if (this.isValidExtensionDir(tmpExtensionDir)) {
                            nextVersionDirectory = ExtensionUtilties.getNextVersionExtensionDir(extensionBundle.getExtensionBundleId());
                            this.copyExtension(tmpExtensionDir, nextVersionDirectory);
                            extensionBundle.setLocalUri(nextVersionDirectory.toURI().toString());
                            needsUpdate = true;
                            continue;
                        }
                        throw new Exception("Not a valid extension structure:" + tmpExtensionDir);
                    }
                    catch (Exception e) {
                        if (ManifestUpdateThread.LOGGER.isLogging(Level.ERROR)) {
                            ManifestUpdateThread.LOGGER.error((Object)("Error while updating \"" + extensionBundle.getExtensionBundleId() + "\": " + e.getMessage()), (Throwable)e);
                        }
                        newUserManifest.getExtensionBundles().remove(extensionBundle);
                        ** for (oldExtensionBundle : userManifest.getExtensionBundles())
                    }
lbl-1000:
                    // 1 sources

                    {
                        if (!oldExtensionBundle.getExtensionBundleId().equals(extensionBundle.getExtensionBundleId())) continue;
                        clone = oldExtensionBundle.clone();
                        newUserManifest.getExtensionBundles().add(clone);
lbl46:
                        // 2 sources

                    }
                }
                if (needsUpdate) {
                    this.addLocalUriInfo(userManifest, newUserManifest);
                    this.saveUserManifest(newUserManifest);
                    this.rebuildManifest(newUserManifest);
                    this.setClearExtensionsFlag(true);
                }
            }
            finally {
                ExtensionUtilties.deleteFiles(tempDir);
            }
        }
    }
}

