/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.csi.internal.extension;

import com.adobe.csi.core.IManifestPersistenceService;
import com.adobe.csi.core.IServiceRegistry;
import com.adobe.csi.core.logging.Level;
import com.adobe.csi.core.logging.Logger;
import com.adobe.csi.extension.IManifestControllerService;
import com.adobe.csi.internal.extension.ManifestUpdateThread;
import java.net.URL;
import javax.xml.parsers.SAXParserFactory;
import org.osgi.service.component.ComponentContext;

public class ManifestControllerService
implements IManifestControllerService {
    static final Logger LOGGER = Logger.getLogger(ManifestControllerService.class);
    private static final String MANIFEST_PERSISTENCE_SERVICE = "MANIFEST_PERSISTENCE_SERVICE";
    private static final String PROP_OZZY_URL = "com.adobe.csi.core.extension.ozzy.url";
    private static final String SAXPARSER_FACTORY = "SAXPARSER_FACTORY";
    private static final String SERVICE_REGISTRY = "SERVICE_REGISTRY";
    private ComponentContext context;

    public void checkForExtensionUpdates(URL url, boolean online) {
        IManifestPersistenceService manifestPersistenceService = (IManifestPersistenceService)this.context.locateService(MANIFEST_PERSISTENCE_SERVICE);
        IServiceRegistry serviceRegistry = (IServiceRegistry)this.context.locateService(SERVICE_REGISTRY);
        SAXParserFactory saxParserFactory = (SAXParserFactory)this.context.locateService(SAXPARSER_FACTORY);
        ManifestUpdateThread manifestUpdateThread = new ManifestUpdateThread();
        manifestUpdateThread.checkForExtensionUpdates(manifestPersistenceService, serviceRegistry, url, saxParserFactory, online);
    }

    public void deleteSuperfluousVersions() {
        IManifestPersistenceService manifestPersistenceService = (IManifestPersistenceService)this.context.locateService(MANIFEST_PERSISTENCE_SERVICE);
        ManifestUpdateThread manifestUpdateThread = new ManifestUpdateThread();
        manifestUpdateThread.deleteSuperfluousVersions(manifestPersistenceService);
    }

    protected void activate(ComponentContext context) throws Exception {
        this.context = context;
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Activating: " + ManifestControllerService.class));
        }
    }

    protected void deactivate(ComponentContext context) {
        if (LOGGER.isLogging(Level.INFO)) {
            LOGGER.info((Object)("Deactivating: " + ManifestControllerService.class));
        }
        this.context = null;
    }
}

